/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.transportRegister;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.transportRegister.Transport;
import com.rugaa.NambaSchool.transportRegister.TransportDao;
import com.rugaa.NambaSchool.transportRegister.TransportDto;
import com.rugaa.NambaSchool.transportRegister.TransportService;
import com.rugaa.NambaSchool.transportRegister.TransportValidation;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TransportServiceImpl
implements TransportService {
    @Autowired
    private TransportDao transportDao;
    @Autowired
    private TransportValidation transportValidation;

    public ApplicationResponse<Transport> createTransport(TransportDto transportDto) {
        try {
            this.transportValidation.validateRequest(transportDto);
            Transport transport = this.mapRequestToEntity(transportDto);
            Transport saveTransport = this.transportDao.saveTransport(transport);
            return ApplicationResponse.success((String)"Successfully create Transport", (Object)saveTransport);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while save transport" + e.getMessage()));
        }
    }

    private Transport mapRequestToEntity(TransportDto transportDto) {
        return Transport.builder().vehicleNumber(transportDto.getVehicleNumber()).vehicleType(transportDto.getVehicleType()).driverName(transportDto.getDriverName()).driverAddress(transportDto.getDriverAddress()).driverMobile(transportDto.getDriverMobile()).emergencyContact(transportDto.getEmergencyContact()).busRoute(transportDto.getBusRoute()).routeType(transportDto.getRouteType()).gpsTracking(transportDto.getGpsTracking()).student(transportDto.getStudent()).staff(transportDto.getStaff()).pickupLocation(transportDto.getPickupLocation()).dropLocation(transportDto.getDropLocation()).build();
    }

    public ApplicationResponse<List<Transport>> getAllTransport() {
        try {
            List list = this.transportDao.getAllTransport();
            if (list.isEmpty()) {
                return ApplicationResponse.error((String)"Transport id is not found");
            }
            return ApplicationResponse.success((String)"Successfully find all transport", (Object)list);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while get all transport" + e.getMessage()));
        }
    }

    public ApplicationResponse<?> findByTransportId(Long id) {
        try {
            Optional optional = this.transportDao.findByTransportId(id);
            if (optional.isPresent()) {
                TransportDto transportDto = this.mapToEntityDto((Transport)optional.get());
                return ApplicationResponse.success((String)"Success transport found successfully", (Object)transportDto);
            }
            return ApplicationResponse.error((String)"Transport id is not found");
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by transport id" + e.getMessage()));
        }
    }

    private TransportDto mapToEntityDto(Transport transport) {
        return TransportDto.builder().id(transport.getId()).vehicleNumber(transport.getVehicleNumber()).vehicleType(transport.getVehicleType()).driverName(transport.getDriverName()).driverAddress(transport.getDriverAddress()).driverMobile(transport.getDriverMobile()).emergencyContact(transport.getEmergencyContact()).busRoute(transport.getBusRoute()).routeType(transport.getRouteType()).student(transport.getStudent()).staff(transport.getStaff()).pickupLocation(transport.getPickupLocation()).dropLocation(transport.getDropLocation()).gpsTracking(transport.getGpsTracking()).build();
    }

    public ApplicationResponse<Transport> deleteByTransportId(Long id) {
        try {
            Optional existTransport = this.transportDao.findByTransportId(id);
            if (existTransport.isEmpty()) {
                return ApplicationResponse.error((String)"Transport id is not found");
            }
            this.transportDao.deleteByTransportId(id);
            return ApplicationResponse.success((String)"transport id is deleted successfully", null);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by transport id" + e.getMessage()));
        }
    }

    public ApplicationResponse<Transport> updateByTransportId(TransportDto transportDto, Long id) {
        try {
            Optional optional = this.transportDao.findByTransportId(id);
            Transport transport = (Transport)optional.get();
            this.updateRequestFromEntity(transport, transportDto);
            Transport saveTransport = this.transportDao.updateByTransportId(transport);
            return ApplicationResponse.success((String)"Succefully update transport id", (Object)saveTransport);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by transport id" + e.getMessage()));
        }
    }

    private void updateRequestFromEntity(Transport transport, TransportDto transportDto) {
        if (transportDto.getVehicleNumber() != null) {
            transport.setVehicleNumber(transportDto.getVehicleNumber());
        }
        if (transportDto.getVehicleType() != null) {
            transport.setVehicleType(transportDto.getVehicleType());
        }
        if (transportDto.getDriverName() != null) {
            transport.setDriverName(transportDto.getDriverName());
        }
        if (transportDto.getDriverAddress() != null) {
            transport.setDriverAddress(transportDto.getDriverAddress());
        }
        if (transportDto.getDriverMobile() != null) {
            transport.setDriverMobile(transportDto.getDriverMobile());
        }
        if (transportDto.getEmergencyContact() != null) {
            transport.setEmergencyContact(transportDto.getEmergencyContact());
        }
        if (transportDto.getBusRoute() != null) {
            transport.setBusRoute(transportDto.getBusRoute());
        }
        if (transportDto.getRouteType() != null) {
            transport.setRouteType(transportDto.getRouteType());
        }
        if (transportDto.getGpsTracking() != null) {
            transport.setGpsTracking(transportDto.getGpsTracking());
        }
        if (transportDto.getStudent() != null) {
            transport.setStudent(transportDto.getStudent());
        }
        if (transportDto.getStaff() != null) {
            transport.setStaff(transportDto.getStaff());
        }
        if (transportDto.getPickupLocation() != null) {
            transport.setPickupLocation(transportDto.getPickupLocation());
        }
        if (transportDto.getDropLocation() != null) {
            transport.setDropLocation(transportDto.getDropLocation());
        }
    }
}

