/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.transportRegister;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.transportRegister.Transport;
import com.rugaa.NambaSchool.transportRegister.TransportDto;
import com.rugaa.NambaSchool.transportRegister.TransportService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/transport"})
public class TransportController {
    @Autowired
    private TransportService transportService;

    @PostMapping(value={"/save"})
    public ApplicationResponse<Transport> createTransport(@RequestBody TransportDto transportDto) {
        try {
            return this.transportService.createTransport(transportDto);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while create transport" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findall"})
    public ApplicationResponse<List<Transport>> getAllTransport() {
        try {
            return this.transportService.getAllTransport();
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find all transport" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findbyid"})
    public ApplicationResponse<?> findByTransportId(@RequestParam Long id) {
        try {
            return this.transportService.findByTransportId(id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by transport id" + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/delete"})
    public ApplicationResponse<Transport> deleteByTransportId(@RequestParam Long id) {
        try {
            return this.transportService.deleteByTransportId(id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by transport id" + e.getMessage()));
        }
    }

    @PostMapping(value={"/update"})
    public ApplicationResponse<Transport> updateByTransportId(@RequestBody TransportDto transportDto, @RequestParam Long id) {
        try {
            return this.transportService.updateByTransportId(transportDto, id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by transport id" + e.getMessage()));
        }
    }
}

