/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.teacher;

import com.rugaa.NambaSchool.exception.ValidationException;
import com.rugaa.NambaSchool.teacher.TeacherDto;
import org.springframework.stereotype.Service;

@Service
public class TeacherValidation {
    public void validateRequest(TeacherDto teacherDto) throws ValidationException {
        if (teacherDto == null) {
            throw new ValidationException("TeacherDto cannot be null");
        }
        if (teacherDto.getFirstName() == null || teacherDto.getFirstName().isEmpty()) {
            throw new ValidationException("First name is required");
        }
        if (teacherDto.getLastName() == null || teacherDto.getLastName().isEmpty()) {
            throw new ValidationException("Last name is required");
        }
        if (teacherDto.getDateOfBirth() == null) {
            throw new ValidationException("Date of birth is required");
        }
        if (teacherDto.getGender() == null || teacherDto.getGender().isEmpty()) {
            throw new ValidationException("Gender is required");
        }
        if (teacherDto.getMobile() == null || !this.isValidMobile(teacherDto.getMobile())) {
            throw new ValidationException("Valid 10-digit mobile number is required");
        }
        if (teacherDto.getEmail() == null || !this.isValidEmail(teacherDto.getEmail())) {
            throw new ValidationException("Email is required");
        }
        if (teacherDto.getCurrentAddress() == null || teacherDto.getCurrentAddress().isEmpty()) {
            throw new ValidationException("Current address is required");
        }
        if (teacherDto.getCity() == null || teacherDto.getCity().isEmpty()) {
            throw new ValidationException("City is required");
        }
        if (teacherDto.getState() == null || teacherDto.getState().isEmpty()) {
            throw new ValidationException("State is required");
        }
        if (teacherDto.getZipCode() == null) {
            throw new ValidationException("Zip code is required");
        }
        if (teacherDto.getDegree() == null || teacherDto.getDegree().isEmpty()) {
            throw new ValidationException("Degree is required");
        }
        if (teacherDto.getInstitution() == null || teacherDto.getInstitution().isEmpty()) {
            throw new ValidationException("Institution name is required");
        }
    }

    private boolean isValidEmail(String email) {
        String emailRegex = "^[\\w-\\.]+@([\\w-]+\\.)+[\\w-]{2,4}$";
        return email.matches(emailRegex);
    }

    private boolean isValidMobile(Long mobile) {
        String mobileRegex = "^[0-9]{10}$";
        return String.valueOf(mobile).matches(mobileRegex);
    }
}

