/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.teacher;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.email.EmailSender;
import com.rugaa.NambaSchool.teacher.TeacherDao;
import com.rugaa.NambaSchool.teacher.TeacherDto;
import com.rugaa.NambaSchool.teacher.TeacherModel;
import com.rugaa.NambaSchool.teacher.TeacherModelMapper;
import com.rugaa.NambaSchool.teacher.TeacherService;
import com.rugaa.NambaSchool.teacher.TeacherValidation;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class TeacherServiceImpl
implements TeacherService {
    @Autowired
    private TeacherDao teacherDao;
    @Autowired
    private PasswordEncoder encoder;
    @Autowired
    private TeacherValidation teacherValidation;
    @Autowired
    private EmailSender emailSender;
    @Autowired
    private TeacherModelMapper teacherModelMapper;

    public ApplicationResponse<TeacherModel> saveteacher(TeacherDto teacherDto) {
        try {
            this.teacherValidation.validateRequest(teacherDto);
            TeacherModel teacherModel = this.teacherModelMapper.mapRequestToEnytity(teacherDto);
            TeacherModel saveteTeacherModel = this.teacherDao.saveteacher(teacherModel);
            return ApplicationResponse.success((String)"Successfully create teacher", (Object)saveteTeacherModel);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while save teacher" + e.getMessage()));
        }
    }

    public ApplicationResponse<List<TeacherDto>> getAll() {
        try {
            List teacherModels = this.teacherDao.getAll();
            if (teacherModels.isEmpty()) {
                return ApplicationResponse.error((String)"Teacher id is not found");
            }
            List teacherDtos = teacherModels.stream().map(arg_0 -> ((TeacherModelMapper)this.teacherModelMapper).mapEntityToDto(arg_0)).collect(Collectors.toList());
            return ApplicationResponse.success((String)"Successfully find all teachers", teacherDtos);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while getAll teacher" + e.getMessage()));
        }
    }

    public ApplicationResponse<TeacherDto> findByTeacherId(Long id) {
        try {
            Optional optional = this.teacherDao.findByTeacherId(id);
            if (optional.isPresent()) {
                TeacherDto teacherDto = this.teacherModelMapper.mapEntityToDto((TeacherModel)optional.get());
                return ApplicationResponse.success((String)"teacher id find successfully", (Object)teacherDto);
            }
            return ApplicationResponse.error((String)"Teacher id is not found");
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by teacher id" + e.getMessage()));
        }
    }

    public ApplicationResponse<TeacherModel> deleteByTeacherId(Long id) {
        try {
            Optional existTeacherId = this.teacherDao.findByTeacherId(id);
            if (existTeacherId.isEmpty()) {
                return ApplicationResponse.error((String)"Teacher id is not found");
            }
            this.teacherDao.deleteByTeacherId(id);
            return ApplicationResponse.success((String)"Teacher id is delete successfully", null);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by teacher id" + e.getMessage()));
        }
    }

    public ApplicationResponse<TeacherModel> updateTeacherById(TeacherDto teacherDto, Long id) {
        try {
            Optional optional = this.teacherDao.findByTeacherId(id);
            TeacherModel teacherModel = (TeacherModel)optional.get();
            this.teacherModelMapper.updateRequestFromEntity(teacherModel, teacherDto);
            TeacherModel saveTeacherModel = this.teacherDao.updateTeacherById(teacherModel);
            return ApplicationResponse.success((String)"Successfully update teacher id", (Object)saveTeacherModel);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred whille update teacher id" + e.getMessage()));
        }
    }
}

