/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.teacher;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.teacher.TeacherDto;
import com.rugaa.NambaSchool.teacher.TeacherModel;
import com.rugaa.NambaSchool.teacher.TeacherService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/teacher"})
public class TeacherController {
    @Autowired
    private TeacherService teacherService;

    @PostMapping(value={"/save"})
    public ApplicationResponse<TeacherModel> saveteacher(@RequestBody TeacherDto teacherDto) {
        try {
            return this.teacherService.saveteacher(teacherDto);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while save teacher" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findall"})
    public ApplicationResponse<List<TeacherDto>> getAll() {
        try {
            return this.teacherService.getAll();
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while get all teacher" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findbyid"})
    public ApplicationResponse<TeacherDto> findByTeacherId(@RequestParam Long id) {
        try {
            return this.teacherService.findByTeacherId(id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while save teacher" + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/delete"})
    public ApplicationResponse<TeacherModel> deleteByTeacherId(@RequestParam Long id) {
        try {
            return this.teacherService.deleteByTeacherId(id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while save teacher" + e.getMessage()));
        }
    }

    @PostMapping(value={"/update"})
    public ApplicationResponse<TeacherModel> updateTeacherById(@RequestBody TeacherDto teacherDto, @RequestParam Long id) {
        try {
            return this.teacherService.updateTeacherById(teacherDto, id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while save teacher" + e.getMessage()));
        }
    }
}

