/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.subjects;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.subjects.Subject;
import com.rugaa.NambaSchool.subjects.SubjectDao;
import com.rugaa.NambaSchool.subjects.SubjectDto;
import com.rugaa.NambaSchool.subjects.SubjectService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SubjectServiceImpl
implements SubjectService {
    @Autowired
    private SubjectDao subjectDao;

    public ApplicationResponse<Subject> createSubject(SubjectDto subjectDto) {
        try {
            Subject subject = this.mapRequestToEntity(subjectDto);
            Subject saveSubject = this.subjectDao.createSubject(subject);
            return ApplicationResponse.success((String)"Succefully create Subject", (Object)saveSubject);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while create Subject" + e.getMessage()));
        }
    }

    private Subject mapRequestToEntity(SubjectDto subjectDto) {
        return Subject.builder().subjectName(subjectDto.getSubjectName()).subjectcode(subjectDto.getSubjectcode()).build();
    }

    public ApplicationResponse<List<Subject>> findAll() {
        try {
            List subjects = this.subjectDao.findAll();
            if (subjects.isEmpty()) {
                return ApplicationResponse.error((String)"Subject is not found");
            }
            return ApplicationResponse.success((String)"Succefully findAll Subject", (Object)subjects);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while findAll Subject" + e.getMessage()));
        }
    }

    public ApplicationResponse<?> findById(Long id) {
        try {
            Optional optional = this.subjectDao.findById(id);
            if (optional.isPresent()) {
                SubjectDto subjectDto = this.mapToEntityDto((Subject)optional.get());
                return ApplicationResponse.success((String)"Succefully findAll Subject", (Object)subjectDto);
            }
            return ApplicationResponse.error((String)"Subject is not found");
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find By Subject id" + e.getMessage()));
        }
    }

    private SubjectDto mapToEntityDto(Subject subject) {
        return SubjectDto.builder().id(subject.getId()).subjectName(subject.getSubjectName()).subjectcode(subject.getSubjectcode()).build();
    }

    public ApplicationResponse<Subject> updateById(SubjectDto subjectDto, Long id) {
        try {
            Optional optional = this.subjectDao.findById(id);
            Subject subject = (Subject)optional.get();
            this.updateRequestFromEntity(subject, subjectDto);
            Subject saveSubject = this.subjectDao.createSubject(subject);
            return ApplicationResponse.success((String)"Succefully update by Subject", (Object)saveSubject);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update By Subject id" + e.getMessage()));
        }
    }

    private void updateRequestFromEntity(Subject subject, SubjectDto subjectDto) {
        if (subjectDto.getSubjectName() != null) {
            subject.setSubjectName(subjectDto.getSubjectName());
        }
        if (subjectDto.getSubjectcode() != null) {
            subject.setSubjectcode(subjectDto.getSubjectcode());
        }
    }

    public ApplicationResponse<Subject> deleteById(Long id) {
        try {
            Optional existSubject = this.subjectDao.findById(id);
            if (existSubject.isEmpty()) {
                return ApplicationResponse.error((String)"Subject id is not found");
            }
            this.subjectDao.deleteById(id);
            return ApplicationResponse.success((String)"Succefully delete by Subject id", null);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete By Subject id" + e.getMessage()));
        }
    }
}

