/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.subjects;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.subjects.Subject;
import com.rugaa.NambaSchool.subjects.SubjectDto;
import com.rugaa.NambaSchool.subjects.SubjectService;
import java.util.List;
import lombok.Generated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/subject"})
public class SubjectController {
    private final SubjectService subjectService;

    @PostMapping(value={"/save"})
    public ApplicationResponse<Subject> createSubject(@RequestBody SubjectDto subjectDto) {
        try {
            return this.subjectService.createSubject(subjectDto);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while createSubject" + e.getMessage()));
        }
    }

    @GetMapping(value={"findall"})
    public ApplicationResponse<List<Subject>> findAll() {
        try {
            return this.subjectService.findAll();
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while findAll" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findbyid"})
    public ApplicationResponse<?> findById(@RequestParam Long id) {
        try {
            return this.subjectService.findById(id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find By Subject id" + e.getMessage()));
        }
    }

    @PostMapping(value={"/updatebyid"})
    public ApplicationResponse<Subject> updateById(@RequestBody SubjectDto subjectDto, @RequestParam Long id) {
        try {
            return this.subjectService.updateById(subjectDto, id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update By Subject id" + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/deletebyid"})
    public ApplicationResponse<Subject> deleteById(@RequestParam Long id) {
        try {
            return this.subjectService.deleteById(id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete By Subject id" + e.getMessage()));
        }
    }

    @Generated
    public SubjectController(SubjectService subjectService) {
        this.subjectService = subjectService;
    }
}

