/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.studentRegister;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.studentRegister.StudentDto;
import org.springframework.stereotype.Service;

@Service
public class StudentValidation {
    public ApplicationResponse<Void> validateRequest(StudentDto studentDto) {
        if (studentDto == null) {
            return ApplicationResponse.error((String)"Student data cannot be null");
        }
        if (this.isNullOrEmpty(studentDto.getFirstName())) {
            return ApplicationResponse.error((String)"First name is required");
        }
        if (this.isNullOrEmpty(studentDto.getLastName())) {
            return ApplicationResponse.error((String)"Last name is required");
        }
        if (studentDto.getDateOfBirth() == null) {
            return ApplicationResponse.error((String)"Date of birth is required");
        }
        if (this.isNullOrEmpty(studentDto.getGender())) {
            return ApplicationResponse.error((String)"Gender is required");
        }
        if (studentDto.getMobile() == null || !this.isValidMobile(studentDto.getMobile())) {
            return ApplicationResponse.error((String)"Valid mobile number is required");
        }
        if (this.isNullOrEmpty(studentDto.getEmail()) || !this.isValidEmail(studentDto.getEmail())) {
            return ApplicationResponse.error((String)"Valid email is required");
        }
        if (this.isNullOrEmpty(studentDto.getPermanentAddress())) {
            return ApplicationResponse.error((String)"Permanent address is required");
        }
        if (this.isNullOrEmpty(studentDto.getCurrentAddress())) {
            return ApplicationResponse.error((String)"Current address is required");
        }
        if (this.isNullOrEmpty(studentDto.getCity())) {
            return ApplicationResponse.error((String)"City is required");
        }
        if (this.isNullOrEmpty(studentDto.getState())) {
            return ApplicationResponse.error((String)"State is required");
        }
        if (studentDto.getZipCode() == null) {
            return ApplicationResponse.error((String)"Zip code is required");
        }
        if (this.isNullOrEmpty(studentDto.getGuardianName())) {
            return ApplicationResponse.error((String)"Guardian name is required");
        }
        if (studentDto.getGuardianMobileNumber() == null || !this.isValidMobile(studentDto.getGuardianMobileNumber())) {
            return ApplicationResponse.error((String)"Valid guardian mobile number is required");
        }
        if (this.isNullOrEmpty(studentDto.getAdmissionNumber())) {
            return ApplicationResponse.error((String)"Admission number is required");
        }
        if (studentDto.getAdmissionDate() == null) {
            return ApplicationResponse.error((String)"Admission date is required");
        }
        if (studentDto.getAcademicYearId() == null) {
            return ApplicationResponse.error((String)"Academic year is required");
        }
        if (studentDto.getCurrentClassId() == null) {
            return ApplicationResponse.error((String)"Current class is required");
        }
        if (studentDto.getSectionId() == null) {
            return ApplicationResponse.error((String)"Section is required");
        }
        if (this.isNullOrEmpty(studentDto.getRollNumber())) {
            return ApplicationResponse.error((String)"Roll number is required");
        }
        if (this.isNullOrEmpty(studentDto.getFatherName())) {
            return ApplicationResponse.error((String)"Father's name is required");
        }
        if (this.isNullOrEmpty(studentDto.getMotherName())) {
            return ApplicationResponse.error((String)"Mother's name is required");
        }
        if (this.isNullOrEmpty(studentDto.getFatherOccupation())) {
            return ApplicationResponse.error((String)"Father's occupation is required");
        }
        if (this.isNullOrEmpty(studentDto.getMotherOccupation())) {
            return ApplicationResponse.error((String)"Mother's occupation is required");
        }
        if (this.isNullOrEmpty(studentDto.getParentEmail()) || !this.isValidEmail(studentDto.getParentEmail())) {
            return ApplicationResponse.error((String)"Valid parent email is required");
        }
        if (this.isNullOrEmpty(studentDto.getBloodGroup())) {
            return ApplicationResponse.error((String)"Blood group is required");
        }
        if (this.isNullOrEmpty(studentDto.getTransportMode())) {
            return ApplicationResponse.error((String)"Transport mode is required");
        }
        if (this.isNullOrEmpty(studentDto.getBusNumber())) {
            return ApplicationResponse.error((String)"Bus number is required");
        }
        if (this.isNullOrEmpty(studentDto.getPickupPoint())) {
            return ApplicationResponse.error((String)"Pickup point is required");
        }
        if (this.isNullOrEmpty(studentDto.getAadharNumber())) {
            return ApplicationResponse.error((String)"Aadhar number is required");
        }
        if (this.isNullOrEmpty(studentDto.getBirthCertificateNumber())) {
            return ApplicationResponse.error((String)"Birth certificate number is required");
        }
        if (this.isNullOrEmpty(studentDto.getStatus())) {
            return ApplicationResponse.error((String)"Status is required");
        }
        return ApplicationResponse.success((String)"Student data is valid", null);
    }

    private boolean isNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    private boolean isValidMobile(Long mobile) {
        String mobileStr = String.valueOf(mobile);
        return mobileStr.matches("^[0-9]{10}$");
    }

    private boolean isValidEmail(String email) {
        return email.matches("^[\\w-\\.]+@([\\w-]+\\.)+[\\w-]{2,4}$");
    }
}

