/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.studentRegister;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.email.EmailSender;
import com.rugaa.NambaSchool.studentRegister.Student;
import com.rugaa.NambaSchool.studentRegister.StudentDao;
import com.rugaa.NambaSchool.studentRegister.StudentDto;
import com.rugaa.NambaSchool.studentRegister.StudentMapper;
import com.rugaa.NambaSchool.studentRegister.StudentService;
import com.rugaa.NambaSchool.studentRegister.StudentValidation;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class StudentServiceImpl
implements StudentService {
    @Autowired
    private StudentDao studentDao;
    @Autowired
    private PasswordEncoder encoder;
    @Autowired
    private StudentValidation studentValidation;
    @Autowired
    private EmailSender emailSender;
    @Autowired
    private StudentMapper studentMapper;

    public ApplicationResponse<Student> saveStudent(StudentDto studentDto, String Token) {
        try {
            Student student = this.studentMapper.mapRequestToEntity(studentDto);
            Student saveStudent = this.studentDao.saveStudent(student);
            return ApplicationResponse.success((String)"Successfully create student details", (Object)saveStudent);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while save student" + e.getMessage()));
        }
    }

    public ApplicationResponse<List<StudentDto>> getAllStudent() {
        try {
            List students = this.studentDao.getAllStudent();
            if (students.isEmpty()) {
                return ApplicationResponse.error((String)"Student id  not found");
            }
            List studentDtos = students.stream().map(arg_0 -> ((StudentMapper)this.studentMapper).mapEntityToDto(arg_0)).collect(Collectors.toList());
            return ApplicationResponse.success((String)"Successfully find all Student", studentDtos);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while get all student" + e.getMessage()));
        }
    }

    public ApplicationResponse<StudentDto> findByStudentId(Long id) {
        try {
            Optional optional = this.studentDao.findByStudentId(id);
            if (optional.isPresent()) {
                StudentDto studentDto = this.studentMapper.mapEntityToDto((Student)optional.get());
                return ApplicationResponse.success((String)"Successfully find Student id", (Object)studentDto);
            }
            return ApplicationResponse.error((String)"Student id is not find");
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by student id" + e.getMessage()));
        }
    }

    public ApplicationResponse<Student> deleteByStudentId(Long id) {
        try {
            Optional existStudentId = this.studentDao.findByStudentId(id);
            if (existStudentId.isEmpty()) {
                return ApplicationResponse.error((String)"Student id is not found");
            }
            this.studentDao.deleteByStudentId(id);
            return ApplicationResponse.success((String)"Student id is delete successfully", null);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by student id" + e.getMessage()));
        }
    }

    public ApplicationResponse<Student> updateByStudentId(StudentDto studentDto, Long id) {
        try {
            Optional stuOptional = this.studentDao.findByStudentId(id);
            Student student = (Student)stuOptional.get();
            this.studentMapper.updateRequestFromEntity(student, studentDto);
            Student saveStudent = this.studentDao.updateByStudentId(student);
            return ApplicationResponse.success((String)"Successfully update student id", (Object)saveStudent);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by student id" + e.getMessage()));
        }
    }

    @Generated
    public StudentServiceImpl() {
    }
}

