/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.studentRegister;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.studentRegister.Student;
import com.rugaa.NambaSchool.studentRegister.StudentDto;
import com.rugaa.NambaSchool.studentRegister.StudentService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/student"})
public class StudentController {
    @Autowired
    private StudentService studentService;

    @PostMapping(value={"/save"})
    public ApplicationResponse<Student> saveStudent(@RequestBody StudentDto studentDto, @RequestHeader(value="Authorization") String token) {
        try {
            return this.studentService.saveStudent(studentDto, token);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while save student" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findall"})
    public ApplicationResponse<List<StudentDto>> getAllStudent() {
        try {
            return this.studentService.getAllStudent();
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while get all student" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findbyid"})
    public ApplicationResponse<StudentDto> findByStudentId(@RequestParam Long id) {
        try {
            return this.studentService.findByStudentId(id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by student id" + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/delete"})
    public ApplicationResponse<Student> deleteByStudentId(@RequestParam Long id) {
        try {
            return this.studentService.deleteByStudentId(id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by student id" + e.getMessage()));
        }
    }

    @PostMapping(value={"/update"})
    public ApplicationResponse<Student> updateByStudentId(@RequestBody StudentDto studentDto, @RequestParam Long id) {
        try {
            return this.studentService.updateByStudentId(studentDto, id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by student id" + e.getMessage()));
        }
    }
}

