/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.sports;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.sports.Sports;
import com.rugaa.NambaSchool.sports.SportsDao;
import com.rugaa.NambaSchool.sports.SportsDto;
import com.rugaa.NambaSchool.sports.SportsService;
import com.rugaa.NambaSchool.sports.SportsValidation;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class SportsServiceImpl
implements SportsService {
    private final SportsDao sportsDao;
    private final SportsValidation sportsValidation;

    public ApplicationResponse<Sports> createSports(SportsDto sportsDto) {
        try {
            this.sportsValidation.validateRequest(sportsDto);
            Sports sports = this.mapRequestToEntity(sportsDto);
            Sports savesSports = this.sportsDao.createSports(sports);
            return ApplicationResponse.success((String)"successfully create sports", (Object)savesSports);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while save sports" + e.getMessage()));
        }
    }

    private Sports mapRequestToEntity(SportsDto sportsDto) {
        return Sports.builder().event(sportsDto.getEvent()).place(sportsDto.getPlace()).date(sportsDto.getDate()).result(sportsDto.getResult()).member(sportsDto.getMember()).build();
    }

    public ApplicationResponse<List<Sports>> findAll() {
        try {
            List sports = this.sportsDao.findAll();
            if (sports.isEmpty()) {
                return ApplicationResponse.error((String)"Sports is not found");
            }
            return ApplicationResponse.success((String)"Successfully find all sports", (Object)sports);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find all sports" + e.getMessage()));
        }
    }

    public ApplicationResponse<?> findById(Long id) {
        try {
            Optional optional = this.sportsDao.findById(id);
            if (optional.isPresent()) {
                SportsDto sportsDto = this.maptoEntityDto((Sports)optional.get());
                return ApplicationResponse.success((String)"Successfully find by sports id", (Object)sportsDto);
            }
            return ApplicationResponse.error((String)"Sports id is nod found");
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by sports id" + e.getMessage()));
        }
    }

    private SportsDto maptoEntityDto(Sports sports) {
        return SportsDto.builder().id(sports.getId()).event(sports.getEvent()).place(sports.getPlace()).date(sports.getDate()).result(sports.getResult()).member(sports.getMember()).build();
    }

    public ApplicationResponse<Sports> updateById(SportsDto sportsDto, Long id) {
        try {
            Optional optional = this.sportsDao.findById(id);
            Sports sports = (Sports)optional.get();
            this.updateRequestFromEntity(sports, sportsDto);
            Sports saveSports = this.sportsDao.createSports(sports);
            return ApplicationResponse.success((String)"Successfully update sports id", (Object)saveSports);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by sports id" + e.getMessage()));
        }
    }

    private void updateRequestFromEntity(Sports sports, SportsDto sportsDto) {
        if (sportsDto.getEvent() != null) {
            sports.setEvent(sportsDto.getEvent());
        }
        if (sportsDto.getPlace() != null) {
            sports.setPlace(sportsDto.getPlace());
        }
        if (sportsDto.getDate() != null) {
            sports.setDate(sportsDto.getDate());
        }
        if (sportsDto.getResult() != null) {
            sports.setResult(sportsDto.getResult());
        }
        if (sportsDto.getMember() != null) {
            sports.setMember(sportsDto.getMember());
        }
    }

    public ApplicationResponse<Sports> deleteById(Long id) {
        try {
            this.sportsDao.deleteById(id);
            return ApplicationResponse.success((String)"Successfully delete Sports id", null);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by sports id" + e.getMessage()));
        }
    }

    @Generated
    public SportsServiceImpl(SportsDao sportsDao, SportsValidation sportsValidation) {
        this.sportsDao = sportsDao;
        this.sportsValidation = sportsValidation;
    }
}

