/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.sports;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.sports.Sports;
import com.rugaa.NambaSchool.sports.SportsDto;
import com.rugaa.NambaSchool.sports.SportsService;
import java.util.List;
import lombok.Generated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/sports"})
public class SportsController {
    private final SportsService sportsService;

    @PostMapping(value={"/save"})
    public ApplicationResponse<Sports> createSports(@RequestBody SportsDto sportsDto) {
        try {
            return this.sportsService.createSports(sportsDto);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while create sports" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findall"})
    public ApplicationResponse<List<Sports>> findAll() {
        try {
            return this.sportsService.findAll();
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find all sports" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findbyid"})
    public ApplicationResponse<?> findById(@RequestParam Long id) {
        try {
            return this.sportsService.findById(id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by sports id" + e.getMessage()));
        }
    }

    @PostMapping(value={"/update"})
    public ApplicationResponse<Sports> updateById(@RequestBody SportsDto sportsDto, @RequestParam Long id) {
        try {
            return this.sportsService.updateById(sportsDto, id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by sports id" + e.getMessage()));
        }
    }

    @DeleteMapping(value={"delete"})
    public ApplicationResponse<Sports> deleteById(@RequestParam Long id) {
        try {
            return this.sportsService.deleteById(id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by sports id" + e.getMessage()));
        }
    }

    @Generated
    public SportsController(SportsService sportsService) {
        this.sportsService = sportsService;
    }
}

