/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.sections;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.sections.Sections;
import com.rugaa.NambaSchool.sections.SectionsDao;
import com.rugaa.NambaSchool.sections.SectionsDto;
import com.rugaa.NambaSchool.sections.SectionsMapper;
import com.rugaa.NambaSchool.sections.SectionsService;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SectionsServiceImpl
implements SectionsService {
    @Autowired
    private SectionsDao sectionsDao;
    @Autowired
    private SectionsMapper sectionsMapper;

    public ApplicationResponse<Sections> createSections(SectionsDto sectionsDto) {
        try {
            Sections sections = this.sectionsMapper.mapRequestToEntity(sectionsDto);
            Sections saveSections = this.sectionsDao.createSections(sections);
            return ApplicationResponse.success((String)"Succefully create Sections", (Object)saveSections);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while create Sections" + e.getMessage()));
        }
    }

    public ApplicationResponse<List<SectionsDto>> findAll() {
        try {
            List sections = this.sectionsDao.findAll();
            if (sections.isEmpty()) {
                return ApplicationResponse.error((String)"Sections is not found");
            }
            List sectionsDtos = sections.stream().map(arg_0 -> ((SectionsMapper)this.sectionsMapper).mapEntityToDto(arg_0)).collect(Collectors.toList());
            return ApplicationResponse.success((String)"Succefully findAll Sections", sectionsDtos);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while findAll Sections" + e.getMessage()));
        }
    }

    public ApplicationResponse<SectionsDto> findById(Long id) {
        try {
            Optional optional = this.sectionsDao.findById(id);
            if (optional.isPresent()) {
                SectionsDto sectionsDto = this.sectionsMapper.mapEntityToDto((Sections)optional.get());
                return ApplicationResponse.success((String)"Succefully findAll Sections", (Object)sectionsDto);
            }
            return ApplicationResponse.error((String)"Sections is not found");
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find By Sections id" + e.getMessage()));
        }
    }

    public ApplicationResponse<Sections> updateById(SectionsDto sectionsDto, Long id) {
        try {
            Optional optional = this.sectionsDao.findById(id);
            Sections sections = (Sections)optional.get();
            this.sectionsMapper.updateRequestFromEntity(sections, sectionsDto);
            Sections saveSections = this.sectionsDao.createSections(sections);
            return ApplicationResponse.success((String)"Succefully update by Sections", (Object)saveSections);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update By Sections id" + e.getMessage()));
        }
    }

    public ApplicationResponse<Sections> deleteById(Long id) {
        try {
            Optional existSections = this.sectionsDao.findById(id);
            if (existSections.isEmpty()) {
                return ApplicationResponse.error((String)"Sections id is not found");
            }
            this.sectionsDao.deleteById(id);
            return ApplicationResponse.success((String)"Succefully delete by Sections id", null);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete By Sections id" + e.getMessage()));
        }
    }
}

