/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.schoolregistration;

import com.rugaa.NambaSchool.exception.ValidationException;
import com.rugaa.NambaSchool.schoolregistration.SchoolRegistrationDto;
import java.time.LocalDate;
import org.springframework.stereotype.Service;

@Service
public class SchoolRegistrationValidation {
    public void validateRequest(SchoolRegistrationDto request) throws ValidationException {
        if (request == null) {
            throw new ValidationException("Request body cannot be null.");
        }
        if (request.getSchoolName() == null || request.getSchoolName().isEmpty()) {
            throw new ValidationException("School name is required.");
        }
        if (request.getSchoolType() == null || request.getSchoolType().isEmpty()) {
            throw new ValidationException("School type is required.");
        }
        if (request.getStreetAddress() == null || request.getStreetAddress().isEmpty()) {
            throw new ValidationException("Street address is required.");
        }
        if (request.getState() == null || request.getState().isEmpty()) {
            throw new ValidationException("State is required.");
        }
        if (request.getCountry() == null || request.getCountry().isEmpty()) {
            throw new ValidationException("Country is required.");
        }
        if (request.getPostalCode() != null && request.getPostalCode().length() > 10) {
            throw new ValidationException("Postal code is too long.");
        }
        if (request.getPhoneNumber() == null || !this.isValidPhoneNumber(request.getPhoneNumber())) {
            throw new ValidationException("Invalid or missing phone number.");
        }
        if (request.getEmailAddress() != null && !this.isValidEmail(request.getEmailAddress())) {
            throw new ValidationException("Invalid email address format.");
        }
        if (request.getPrimaryBoard() == null || request.getPrimaryBoard().isEmpty()) {
            throw new ValidationException("Primary board affiliation is required.");
        }
        if (Boolean.TRUE.equals(request.getIsGovernmentRegistered()) && (request.getRegistrationNumber() == null || request.getRegistrationNumber().isEmpty())) {
            throw new ValidationException("Registration number is required for government-registered schools.");
        }
        if (Boolean.TRUE.equals(request.getHasGSTCertificate()) && (request.getGstNumber() == null || request.getGstNumber().isEmpty())) {
            throw new ValidationException("GST number is required for schools with GST certification.");
        }
        if (request.getGstIssueDate() != null && request.getGstIssueDate().isAfter(LocalDate.now())) {
            throw new ValidationException("GST issue date cannot be in the future.");
        }
        if (request.getPrincipalName() == null || request.getPrincipalName().isEmpty()) {
            throw new ValidationException("Principal name is required.");
        }
        if (request.getPrincipalContactPhone() == null || !this.isValidPhoneNumber(request.getPrincipalContactPhone())) {
            throw new ValidationException("Invalid or missing principal contact phone.");
        }
        if (request.getPrincipalContactEmail() != null && !this.isValidEmail(request.getPrincipalContactEmail())) {
            throw new ValidationException("Invalid principal contact email.");
        }
        if (request.getSchoolManagementType() == null || request.getSchoolManagementType().isEmpty()) {
            throw new ValidationException("School management type is required.");
        }
        if (request.getGovernmentRegistrationDocument() == null || request.getGovernmentRegistrationDocument().isEmpty()) {
            throw new ValidationException("Government registration document is required.");
        }
        if (request.getGstDocument() == null || request.getGstDocument().isEmpty()) {
            throw new ValidationException("GST document is required.");
        }
        if (request.getTermsAgreed() == null || !request.getTermsAgreed().booleanValue()) {
            throw new ValidationException("Terms and conditions must be agreed upon.");
        }
        if (request.getConfirmAgreed() == null || !request.getConfirmAgreed().booleanValue()) {
            throw new ValidationException("Confirmation of agreement is required.");
        }
    }

    private boolean isValidEmail(String email) {
        String emailRegex = "^[\\w-\\.]+@([\\w-]+\\.)+[\\w-]{2,4}$";
        return email.matches(emailRegex);
    }

    private boolean isValidPhoneNumber(String phoneNumber) {
        String phoneRegex = "^[0-9]{10}$";
        return phoneNumber.matches(phoneRegex);
    }
}

