/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.schoolregistration;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.appplicationresponse.ResponseBannerDto;
import com.rugaa.NambaSchool.authentication.AuthenticationResponse;
import com.rugaa.NambaSchool.profilePhotos.PhotoService;
import com.rugaa.NambaSchool.schoolregistration.SchoolLoginRequest;
import com.rugaa.NambaSchool.schoolregistration.SchoolRegistration;
import com.rugaa.NambaSchool.schoolregistration.SchoolRegistrationDto;
import com.rugaa.NambaSchool.schoolregistration.SchoolRegistrationService;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/school-registration"})
public class SchoolRegistrationController {
    private final SchoolRegistrationService schoolRegistrationService;
    private final PhotoService photoService;

    @PutMapping(value={"/register"})
    public ApplicationResponse<AuthenticationResponse> register(@RequestBody SchoolLoginRequest request) {
        return this.schoolRegistrationService.register(request);
    }

    @PostMapping(value={"/save"})
    public ApplicationResponse<SchoolRegistration> createSchool(@RequestBody SchoolRegistrationDto schoolRegistration, @RequestHeader(value="Authorization") String token) {
        return this.schoolRegistrationService.createSchool(schoolRegistration, token);
    }

    @GetMapping(value={"/get/{id}"})
    public ApplicationResponse<SchoolRegistrationDto> getSchoolById(@PathVariable Long id, @RequestHeader(value="Authorization") String token) {
        return this.schoolRegistrationService.getSchoolById(id, token);
    }

    @Cacheable(value={"schools"})
    @GetMapping(value={"/getall"})
    public ApplicationResponse<List<SchoolRegistrationDto>> getAllSchools(@RequestHeader(value="Authorization") String token) {
        return this.schoolRegistrationService.getAllSchools(token);
    }

    @PostMapping(value={"/update"})
    public ApplicationResponse<SchoolRegistration> updateSchool(@RequestBody SchoolRegistrationDto schoolRegistration, @RequestHeader(value="Authorization") String token) {
        Long id = schoolRegistration.getId();
        return this.schoolRegistrationService.updateSchool(id, schoolRegistration, token);
    }

    @DeleteMapping(value={"/{id}"})
    public ApplicationResponse<Void> deleteSchool(@PathVariable Long id) {
        return this.schoolRegistrationService.deleteSchool(id);
    }

    @Async
    @PutMapping(value={"/addprofile"})
    public CompletableFuture<ApplicationResponse<ResponseBannerDto>> addProfile(@RequestParam MultipartFile file) {
        try {
            ResponseBannerDto response = this.photoService.addProfile(file);
            ApplicationResponse applicationResponse = new ApplicationResponse();
            applicationResponse.setData((Object)response);
            applicationResponse.setMessage("Profile added successfully.");
            applicationResponse.setStatus("SUCCESS");
            return CompletableFuture.completedFuture(applicationResponse);
        }
        catch (Exception e) {
            ApplicationResponse applicationResponse = new ApplicationResponse();
            applicationResponse.setMessage("An error occurred while adding profile: " + e.getMessage());
            applicationResponse.setStatus("FAILURE");
            return CompletableFuture.completedFuture(applicationResponse);
        }
    }

    @Generated
    public SchoolRegistrationController(SchoolRegistrationService schoolRegistrationService, PhotoService photoService) {
        this.schoolRegistrationService = schoolRegistrationService;
        this.photoService = photoService;
    }
}

