/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.schoolTimeTable;

import com.rugaa.NambaSchool.exception.ValidationException;
import com.rugaa.NambaSchool.schoolTimeTable.TimeTableDto;
import org.springframework.stereotype.Service;

@Service
public class TimeTableValidation {
    public void validateRequest(TimeTableDto timetableDto) throws ValidationException {
        if (timetableDto == null) {
            throw new ValidationException("TimetableDto cannot be null");
        }
        if (timetableDto.getSection() == null || timetableDto.getSection().isEmpty()) {
            throw new ValidationException("Section is required");
        }
        if (timetableDto.getSubject() == null || timetableDto.getSubject().isEmpty()) {
            throw new ValidationException("Subject is required");
        }
        if (timetableDto.getStartTime() == null) {
            throw new ValidationException("Start time is required");
        }
        if (timetableDto.getEndTime() == null) {
            throw new ValidationException("End time is required");
        }
        if (timetableDto.getStartTime() != null && timetableDto.getEndTime() != null && timetableDto.getEndTime().isBefore(timetableDto.getStartTime())) {
            throw new ValidationException("End time cannot be before start time");
        }
        if (timetableDto.getDayOfWeek() == null || timetableDto.getDayOfWeek().isEmpty()) {
            throw new ValidationException("Day of the week is required");
        }
        if (timetableDto.getTeacherId() == null) {
            throw new ValidationException("Teacher ID is required");
        }
    }
}

