/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.schoolTimeTable;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.schoolTimeTable.TimeTable;
import com.rugaa.NambaSchool.schoolTimeTable.TimeTableDao;
import com.rugaa.NambaSchool.schoolTimeTable.TimeTableDto;
import com.rugaa.NambaSchool.schoolTimeTable.TimeTableService;
import com.rugaa.NambaSchool.schoolTimeTable.TimeTableValidation;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TimeTableServiceImpl
implements TimeTableService {
    @Autowired
    private TimeTableDao timeTableDao;
    @Autowired
    private TimeTableValidation timeTableValidation;

    public ApplicationResponse<TimeTable> saveTimeTable(TimeTableDto timeTableDto) {
        try {
            this.timeTableValidation.validateRequest(timeTableDto);
            TimeTable table = this.mapRequestToEntity(timeTableDto);
            TimeTable saveTimeTable = this.timeTableDao.saveTimeTable(table);
            return ApplicationResponse.success((String)"Successfully create timetable", (Object)saveTimeTable);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while save timetable" + e.getMessage()));
        }
    }

    private TimeTable mapRequestToEntity(TimeTableDto timeTableDto) {
        return TimeTable.builder().section(timeTableDto.getSection()).subject(timeTableDto.getSubject()).startTime(timeTableDto.getStartTime()).endTime(timeTableDto.getEndTime()).dayOfWeek(timeTableDto.getDayOfWeek()).teacherId(timeTableDto.getTeacherId()).build();
    }

    public ApplicationResponse<List<TimeTable>> getAllTimeTable() {
        try {
            List list = this.timeTableDao.getAllTimeTable();
            if (list.isEmpty()) {
                return ApplicationResponse.error((String)"time table id is not found");
            }
            return ApplicationResponse.success((String)"Successfully find all timetable", (Object)list);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find all timetable" + e.getMessage()));
        }
    }

    public ApplicationResponse<?> findByTimeTableId(Long id) {
        try {
            Optional optional = this.timeTableDao.findByTimeTableId(id);
            if (optional.isPresent()) {
                TimeTableDto timeTableDto = this.mapToEntityDto((TimeTable)optional.get());
                return ApplicationResponse.success((String)"Timetable found successfully", (Object)timeTableDto);
            }
            return ApplicationResponse.error((String)"time table id is not found");
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by timetable id" + e.getMessage()));
        }
    }

    private TimeTableDto mapToEntityDto(TimeTable timeTable) {
        return TimeTableDto.builder().id(timeTable.getId()).section(timeTable.getSection()).subject(timeTable.getSubject()).startTime(timeTable.getStartTime()).endTime(timeTable.getEndTime()).dayOfWeek(timeTable.getDayOfWeek()).teacherId(timeTable.getTeacherId()).build();
    }

    public ApplicationResponse<TimeTable> deleteBytimeTableId(Long id) {
        try {
            Optional existTimetable = this.timeTableDao.findByTimeTableId(id);
            if (existTimetable.isEmpty()) {
                return ApplicationResponse.error((String)"time table id is not found");
            }
            this.timeTableDao.deleteBytimeTableId(id);
            return ApplicationResponse.success((String)"Successfully delete time table id", null);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by timetable id" + e.getMessage()));
        }
    }

    public ApplicationResponse<TimeTable> updateByTimetableId(Long id, TimeTableDto timeTableDto) {
        try {
            Optional optional = this.timeTableDao.findByTimeTableId(id);
            TimeTable table = (TimeTable)optional.get();
            this.updateRequestFromEntity(table, timeTableDto);
            TimeTable saveTimeTable = this.timeTableDao.updateByTimetableId(table);
            return ApplicationResponse.success((String)"Successfully update time table id", (Object)saveTimeTable);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by timetable id" + e.getMessage()));
        }
    }

    private void updateRequestFromEntity(TimeTable table, TimeTableDto timeTableDto) {
        if (timeTableDto.getSection() != null) {
            table.setSection(timeTableDto.getSection());
        }
        if (timeTableDto.getSubject() != null) {
            table.setSubject(timeTableDto.getSubject());
        }
        if (timeTableDto.getStartTime() != null) {
            table.setStartTime(timeTableDto.getStartTime());
        }
        if (timeTableDto.getEndTime() != null) {
            table.setEndTime(timeTableDto.getEndTime());
        }
        if (timeTableDto.getDayOfWeek() != null) {
            table.setDayOfWeek(timeTableDto.getDayOfWeek());
        }
        if (timeTableDto.getTeacherId() != null) {
            table.setTeacherId(timeTableDto.getTeacherId());
        }
    }
}

