/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.schoolTimeTable;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.schoolTimeTable.TimeTable;
import com.rugaa.NambaSchool.schoolTimeTable.TimeTableDto;
import com.rugaa.NambaSchool.schoolTimeTable.TimeTableService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/timetable"})
public class TimeTableController {
    @Autowired
    private TimeTableService timeTableService;

    @PostMapping(value={"/save"})
    public ApplicationResponse<TimeTable> saveTimeTable(@RequestBody TimeTableDto timeTableDto) {
        try {
            return this.timeTableService.saveTimeTable(timeTableDto);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while save timetable" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findall"})
    public ApplicationResponse<List<TimeTable>> getAllTimeTable() {
        try {
            return this.timeTableService.getAllTimeTable();
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find all timetable" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findbyid"})
    public ApplicationResponse<?> findByTimeTableId(@RequestParam Long id) {
        try {
            return this.timeTableService.findByTimeTableId(id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by timetable id" + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/delete"})
    public ApplicationResponse<TimeTable> deleteBytimeTableId(@RequestParam Long id) {
        try {
            return this.timeTableService.deleteBytimeTableId(id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by timetable id" + e.getMessage()));
        }
    }

    @PostMapping(value={"/update"})
    public ApplicationResponse<TimeTable> updateByTimetableId(@RequestBody TimeTableDto timeTableDto, @RequestParam Long id) {
        try {
            return this.timeTableService.updateByTimetableId(id, timeTableDto);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by timetable id" + e.getMessage()));
        }
    }
}

