/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.schoolEvent;

import com.rugaa.NambaSchool.exception.ValidationException;
import com.rugaa.NambaSchool.schoolEvent.EventDto;
import org.springframework.stereotype.Service;

@Service
public class EventValidation {
    public void validateRequest(EventDto eventDto) throws ValidationException {
        if (eventDto == null) {
            throw new ValidationException("eventDto cannot be null");
        }
        if (eventDto.getTitle() == null || eventDto.getTitle().isEmpty()) {
            throw new ValidationException("Title is required");
        }
        if (eventDto.getEventName() == null || eventDto.getEventName().isEmpty()) {
            throw new ValidationException("Event name is required");
        }
        if (eventDto.getStartDate() == null) {
            throw new ValidationException("Start date is required");
        }
        if (eventDto.getEndDate() == null) {
            throw new ValidationException("End date is required");
        }
        if (eventDto.getStartDate() != null && eventDto.getEndDate() != null && eventDto.getEndDate().isBefore(eventDto.getStartDate())) {
            throw new ValidationException("End date cannot be before start date");
        }
        if (eventDto.getDescription() == null || eventDto.getDescription().isEmpty()) {
            throw new ValidationException("Description is required");
        }
        if (eventDto.getLastModifiedDate() == null) {
            throw new ValidationException("LastModifiedDate is required");
        }
    }
}

