/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.schoolEvent;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.schoolEvent.Event;
import com.rugaa.NambaSchool.schoolEvent.EventDao;
import com.rugaa.NambaSchool.schoolEvent.EventDto;
import com.rugaa.NambaSchool.schoolEvent.EventService;
import com.rugaa.NambaSchool.schoolEvent.EventValidation;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EventServiceImpl
implements EventService {
    @Autowired
    private EventDao eventDao;
    @Autowired
    private EventValidation validation;

    public ApplicationResponse<Event> createEvent(EventDto eventDto) {
        try {
            this.validation.validateRequest(eventDto);
            Event event = this.mapRequestToEntity(eventDto);
            Event saveEvent = this.eventDao.createEvent(event);
            return ApplicationResponse.success((String)"Successfully create event", (Object)saveEvent);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while create event" + e.getMessage()));
        }
    }

    private Event mapRequestToEntity(EventDto eventDto) {
        return Event.builder().title(eventDto.getTitle()).eventName(eventDto.getEventName()).startDate(eventDto.getStartDate()).endDate(eventDto.getEndDate()).description(eventDto.getDescription()).createdTimeStamp(eventDto.getCreatedTimeStamp()).lastModifiedDate(eventDto.getLastModifiedDate()).build();
    }

    public ApplicationResponse<Event> updateByEventId(EventDto eventDto, Long id) {
        try {
            Optional optional = this.eventDao.findByEventId(id);
            Event event = (Event)optional.get();
            this.updateRequestFromEntity(event, eventDto);
            Event saveEvent = this.eventDao.updateByEventId(event);
            return ApplicationResponse.success((String)"Successfully update event ", (Object)saveEvent);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by event id" + e.getMessage()));
        }
    }

    private void updateRequestFromEntity(Event event, EventDto eventDto) {
        if (eventDto.getTitle() != null) {
            event.setTitle(eventDto.getTitle());
        }
        if (eventDto.getEventName() != null) {
            event.setEventName(eventDto.getEventName());
        }
        if (eventDto.getDescription() != null) {
            event.setDescription(eventDto.getDescription());
        }
        if (eventDto.getStartDate() != null) {
            event.setStartDate(eventDto.getStartDate());
        }
        if (eventDto.getEndDate() != null) {
            event.setEndDate(eventDto.getEndDate());
        }
        if (eventDto.getCreatedTimeStamp() != null) {
            event.setCreatedTimeStamp(eventDto.getCreatedTimeStamp());
        }
        if (eventDto.getLastModifiedDate() != null) {
            event.setLastModifiedDate(eventDto.getLastModifiedDate());
        }
    }

    public ApplicationResponse<List<Event>> fetchAll() {
        try {
            List list = this.eventDao.fetchAll();
            if (list.isEmpty()) {
                return ApplicationResponse.error((String)"Event not found");
            }
            return ApplicationResponse.success((String)"Successfully find all event", (Object)list);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find all event" + e.getMessage()));
        }
    }

    public ApplicationResponse<?> findByEventId(Long id) {
        try {
            Optional optional = this.eventDao.findByEventId(id);
            if (optional.isPresent()) {
                EventDto eventDto = this.mapToEntityDto((Event)optional.get());
                return ApplicationResponse.success((String)"Successfully find event id", (Object)eventDto);
            }
            return ApplicationResponse.error((String)"event id is not found");
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by event id" + e.getMessage()));
        }
    }

    private EventDto mapToEntityDto(Event event) {
        return EventDto.builder().id(event.getId()).title(event.getTitle()).eventName(event.getEventName()).startDate(event.getStartDate()).endDate(event.getEndDate()).description(event.getDescription()).createdTimeStamp(event.getCreatedTimeStamp()).lastModifiedDate(event.getLastModifiedDate()).build();
    }

    public ApplicationResponse<Event> deleteByEventId(Long id) {
        try {
            Optional existEvent = this.eventDao.findByEventId(id);
            if (existEvent.isEmpty()) {
                return ApplicationResponse.error((String)"event id is not found");
            }
            this.eventDao.deleteByEventId(id);
            return ApplicationResponse.success((String)"Event id is deleted successfully", null);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by event id" + e.getMessage()));
        }
    }
}

