/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.profilePhotos;

import com.rugaa.NambaSchool.appplicationresponse.ResponseBannerDto;
import com.rugaa.NambaSchool.profilePhotos.FileService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PhotoService {
    @Autowired
    private FileService fileService;

    public ResponseBannerDto addProfile(MultipartFile file) {
        try {
            if (file.isEmpty()) {
                throw new IllegalArgumentException("file cacnot be empty");
            }
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("ddMMyyyyHHmmssSS");
            LocalDateTime current = LocalDateTime.now();
            String extension = file.getContentType();
            if (extension == null) {
                throw new IllegalArgumentException("Invalid file type");
            }
            String exe = extension.substring(extension.lastIndexOf("/") + 1);
            String fileName = dtf.format(current) + "." + exe;
            String remotePath = "/school-registation" + fileName;
            this.fileService.upload(remotePath, file);
            String uploadedUrl = "https://storage.megashop.my" + remotePath;
            ResponseBannerDto bannerDto = new ResponseBannerDto(uploadedUrl);
            return new ResponseBannerDto(uploadedUrl);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Error: " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error occurred while processing the file: " + e.getMessage());
        }
    }
}

