/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.password;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.authentication.AuthenticationService;
import com.rugaa.NambaSchool.authentication.UserResponse;
import com.rugaa.NambaSchool.otp.OTPService;
import com.rugaa.NambaSchool.password.PasswordChangeRequest;
import com.rugaa.NambaSchool.password.PasswordService;
import com.rugaa.NambaSchool.user.User;
import com.rugaa.NambaSchool.user.UserDao;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class PasswordServiceImpl<T>
implements PasswordService {
    @Autowired
    private AuthenticationService authenticationService;
    @Autowired
    private PasswordEncoder encoder;
    @Autowired
    private UserDao userDao;
    @Autowired
    private OTPService otpService;

    public ResponseEntity<?> changePassword(PasswordChangeRequest changeRequest, String token) {
        try {
            PasswordChangeRequest password = this.authenticationService.getPassDetails(token);
            if (!this.encoder.matches((CharSequence)changeRequest.getOldPassword(), password.getOldPassword())) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Old Password is incorrect");
            }
            if (!changeRequest.getNewPassword().equals(changeRequest.getReenterPassword())) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"New password and re enter password do not match");
            }
            Optional userOTP = this.userDao.findById(changeRequest.getId());
            if (userOTP.isEmpty()) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).body((Object)"User not found");
            }
            User user = (User)userOTP.get();
            String newPassword = changeRequest.getNewPassword();
            user.setPassword(this.encoder.encode((CharSequence)newPassword));
            this.userDao.save(user);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)"Password change successfuly");
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while change password" + e.getMessage()));
        }
    }

    public ApplicationResponse<T> forgetPassword(UserResponse response) {
        try {
            System.out.println("response.getEmail()" + response.getEmail());
            if (response.getEmail() == null) {
                return new ApplicationResponse("Error", "Email is required", null);
            }
            Optional user = this.userDao.findByEmail(response.getEmail());
            if (user.isPresent()) {
                return new ApplicationResponse("Error", "User not found with the provided email", null);
            }
            if (response.getOtp() == null) {
                return new ApplicationResponse("Error", "User not found with the provided email", null);
            }
            if (response.getPassword() == null) {
                return new ApplicationResponse("Error", "User not found with the provided email", null);
            }
            boolean isverifyOTP = this.otpService.verifyOTP(response.getEmail(), response.getOtp());
            if (isverifyOTP) {
                return new ApplicationResponse("Error", "Invalid OTP", null);
            }
            ((User)user.get()).setPassword(this.encoder.encode((CharSequence)response.getPassword()));
            this.userDao.save((User)user.get());
            return new ApplicationResponse("Success", "Password change succefully", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ApplicationResponse("Error", "An unexpected occurred error please try again later", null);
        }
    }
}

