/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.otp;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.email.EmailSender;
import com.rugaa.NambaSchool.exception.DatabaseException;
import com.rugaa.NambaSchool.exception.EmailSendingException;
import com.rugaa.NambaSchool.exception.OTPGenerationException;
import com.rugaa.NambaSchool.exception.OTPVerificationException;
import com.rugaa.NambaSchool.exception.UserNotFoundException;
import com.rugaa.NambaSchool.otp.OTPDto;
import com.rugaa.NambaSchool.otp.OTPService;
import com.rugaa.NambaSchool.user.UserDao;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class OTPServiceImpl {
    @Autowired
    private EmailSender javaSendApi;
    @Autowired
    private OTPService otpService;
    @Autowired
    private UserDao userDao;
    private static final Logger logger = LoggerFactory.getLogger(OTPServiceImpl.class);

    @Async
    public CompletableFuture<ApplicationResponse<String>> sendOtp(OTPDto dto) {
        try {
            logger.info("Starting OTP generation for account creation");
            String otp = this.otpService.generateOTP();
            logger.debug("OTP generated: {}", (Object)otp);
            this.otpService.storeOTPInDatabase(dto.getEmail(), otp);
            logger.debug("OTP stored in database for email: {}", (Object)dto.getEmail());
            this.javaSendApi.sendOtpEmail(dto.getEmail(), otp);
            return CompletableFuture.completedFuture(ApplicationResponse.success((String)"Success", (Object)"OTP has been sent to your email for account creation"));
        }
        catch (OTPGenerationException e) {
            logger.error("Error generating OTP: {}", (Object)e.getMessage(), (Object)e);
            return CompletableFuture.completedFuture(ApplicationResponse.error((String)"Failed to generate OTP. Please try again later."));
        }
        catch (DatabaseException e) {
            logger.error("Error storing OTP in database: {}", (Object)e.getMessage(), (Object)e);
            return CompletableFuture.completedFuture(ApplicationResponse.error((String)"Failed to store OTP. Please try again later."));
        }
        catch (EmailSendingException e) {
            logger.error("Error sending OTP email: {}", (Object)e.getMessage(), (Object)e);
            return CompletableFuture.completedFuture(ApplicationResponse.error((String)"Failed to send OTP email. Please try again later."));
        }
        catch (Exception e) {
            logger.error("Unexpected error: {}", (Object)e.getMessage(), (Object)e);
            return CompletableFuture.completedFuture(ApplicationResponse.error((String)("Something went wrong while sending the OTP. " + e.getMessage())));
        }
    }

    @Async
    public CompletableFuture<ApplicationResponse<String>> sendOtpForForgotPassword(OTPDto dto) {
        try {
            logger.info("Starting OTP generation for forgot password request");
            Optional optional = this.userDao.findByEmail(dto.getEmail());
            if (optional.isEmpty()) {
                throw new UserNotFoundException("No account associated with the provided email address");
            }
            String otp = this.otpService.generateOTP();
            logger.debug("OTP generated: {}", (Object)otp);
            this.otpService.storeOTPInDatabase(dto.getEmail(), otp);
            logger.debug("OTP stored in database for email: {}", (Object)dto.getEmail());
            String body = this.javaSendApi.buildForgotPasswordEmailBody(otp);
            this.javaSendApi.sendForgotPasswordEmail(dto.getEmail(), body);
            return CompletableFuture.completedFuture(ApplicationResponse.success((String)"Success", (Object)"OTP has been sent to your email for password reset"));
        }
        catch (Exception e) {
            logger.error("Error processing OTP request: {}", (Object)e.getMessage(), (Object)e);
            CompletableFuture<ApplicationResponse<String>> future = new CompletableFuture<ApplicationResponse<String>>();
            future.completeExceptionally(e);
            return future;
        }
    }

    public ApplicationResponse<String> otpverification(OTPDto dto) {
        try {
            logger.info("Starting OTP verification for email: {}", (Object)dto.getEmail());
            Boolean verified = this.otpService.verifyOTP(dto.getEmail(), dto.getOtp());
            if (verified.booleanValue()) {
                return ApplicationResponse.success((String)"Success", (Object)"OTP verified successfully. Account creation can proceed.");
            }
            return ApplicationResponse.error((String)"Invalid OTP. Please verify and try again.");
        }
        catch (OTPVerificationException e) {
            logger.error("OTP verification failed for email {}: {}", new Object[]{dto.getEmail(), e.getMessage(), e});
            return ApplicationResponse.error((String)("OTP verification failed. " + e.getMessage()));
        }
        catch (DatabaseException e) {
            logger.error("Error fetching OTP from the database: {}", (Object)e.getMessage(), (Object)e);
            return ApplicationResponse.error((String)"Database error during OTP verification. Please try again later.");
        }
        catch (Exception e) {
            logger.error("Unexpected error during OTP verification: {}", (Object)e.getMessage(), (Object)e);
            return ApplicationResponse.error((String)"An error occurred while verifying OTP. Please try again later.");
        }
    }
}

