/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.otp;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.exception.DatabaseException;
import com.rugaa.NambaSchool.exception.EmailSendingException;
import com.rugaa.NambaSchool.exception.OTPGenerationException;
import com.rugaa.NambaSchool.exception.UserNotFoundException;
import com.rugaa.NambaSchool.otp.OTPDto;
import com.rugaa.NambaSchool.otp.OTPServiceImpl;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/otp"})
public class OTPController {
    @Autowired
    private OTPServiceImpl otpServiceImpl;

    @PutMapping(value={"/sendotp"})
    public ApplicationResponse<?> sendotp(@RequestBody OTPDto dto) {
        try {
            CompletableFuture response = this.otpServiceImpl.sendOtp(dto);
            return ApplicationResponse.success((String)"OTP sent successfully", (Object)response);
        }
        catch (OTPGenerationException e) {
            return ApplicationResponse.error((String)("Error generating OTP: " + e.getMessage()));
        }
        catch (DatabaseException e) {
            return ApplicationResponse.error((String)("Error storing OTP in the database: " + e.getMessage()));
        }
        catch (EmailSendingException e) {
            return ApplicationResponse.error((String)("Error sending OTP email: " + e.getMessage()));
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An unexpected error occurred: " + e.getMessage()));
        }
    }

    @PutMapping(value={"/forgototp"})
    public ApplicationResponse<?> forgototp(@RequestBody OTPDto dto) {
        try {
            ApplicationResponse response = (ApplicationResponse)this.otpServiceImpl.sendOtpForForgotPassword(dto).get();
            return ApplicationResponse.success((String)"OTP sent successfully", (Object)((String)response.getData()));
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof UserNotFoundException) {
                return ApplicationResponse.error((String)("User not found: " + cause.getMessage()));
            }
            if (cause instanceof OTPGenerationException) {
                return ApplicationResponse.error((String)("Error generating OTP: " + cause.getMessage()));
            }
            if (cause instanceof DatabaseException) {
                return ApplicationResponse.error((String)("Error storing OTP in the database: " + cause.getMessage()));
            }
            if (cause instanceof EmailSendingException) {
                return ApplicationResponse.error((String)("Error sending OTP email: " + cause.getMessage()));
            }
            return ApplicationResponse.error((String)("An unexpected error occurred: " + cause.getMessage()));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return ApplicationResponse.error((String)"Request was interrupted. Please try again.");
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An unexpected error occurred: " + e.getMessage()));
        }
    }

    @PutMapping(value={"/otpverification"})
    public ApplicationResponse<String> otpverification(@RequestBody OTPDto dto) {
        try {
            ApplicationResponse result = this.otpServiceImpl.otpverification(dto);
            return result;
        }
        catch (OTPGenerationException e) {
            return ApplicationResponse.error((String)("Error generating OTP: " + e.getMessage()));
        }
        catch (DatabaseException e) {
            return ApplicationResponse.error((String)("Error storing OTP in the database: " + e.getMessage()));
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred during OTP verification: " + e.getMessage()));
        }
    }
}

