/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.notice;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.notice.NoticeBoard;
import com.rugaa.NambaSchool.notice.NoticeBoardDao;
import com.rugaa.NambaSchool.notice.NoticeBoardDto;
import com.rugaa.NambaSchool.notice.NoticeBoardService;
import com.rugaa.NambaSchool.notice.NoticeBoardValidation;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NoticeBoardServiceImpl
implements NoticeBoardService {
    @Autowired
    private NoticeBoardDao noticeBoardDao;
    @Autowired
    private NoticeBoardValidation noticeBoardValidation;

    public ApplicationResponse<NoticeBoard> createNoticeBoard(NoticeBoardDto noticeBoardDto) {
        try {
            this.noticeBoardValidation.validationRequest(noticeBoardDto);
            NoticeBoard board = this.mapRequestToEntity(noticeBoardDto);
            NoticeBoard saveNoticeBoard = this.noticeBoardDao.createNoticeBoard(board);
            return ApplicationResponse.success((String)"Successfully create NoticeBoard", (Object)saveNoticeBoard);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while cerate notice board" + e.getMessage()));
        }
    }

    private NoticeBoard mapRequestToEntity(NoticeBoardDto noticeBoardDto) {
        return NoticeBoard.builder().title(noticeBoardDto.getTitle()).description(noticeBoardDto.getDescription()).content(noticeBoardDto.getContent()).date(noticeBoardDto.getDate()).image(noticeBoardDto.getImage()).build();
    }

    public ApplicationResponse<NoticeBoard> upadteByNoticeBoardId(NoticeBoardDto noticeBoardDto, Long id) {
        try {
            Optional optional = this.noticeBoardDao.findById(id);
            NoticeBoard board = (NoticeBoard)optional.get();
            this.updateRequestFromEntity(board, noticeBoardDto);
            NoticeBoard saveNoticeBoard = this.noticeBoardDao.upadteByNoticeBoardId(board);
            return ApplicationResponse.success((String)"Succesfully update noticeBoard id", (Object)saveNoticeBoard);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update notice board" + e.getMessage()));
        }
    }

    private void updateRequestFromEntity(NoticeBoard board, NoticeBoardDto noticeBoardDto) {
        if (noticeBoardDto.getTitle() != null) {
            board.setTitle(noticeBoardDto.getTitle());
        }
        if (noticeBoardDto.getDescription() != null) {
            board.setDescription(noticeBoardDto.getDescription());
        }
        if (noticeBoardDto.getContent() != null) {
            board.setContent(noticeBoardDto.getContent());
        }
        if (noticeBoardDto.getDate() != null) {
            board.setDate(noticeBoardDto.getDate());
        }
        if (noticeBoardDto.getImage() != null) {
            board.setImage(noticeBoardDto.getImage());
        }
    }

    public ApplicationResponse<List<NoticeBoard>> fetchAll() {
        try {
            List list = this.noticeBoardDao.fetchAll();
            if (list.isEmpty()) {
                return ApplicationResponse.error((String)"Notice board not found");
            }
            return ApplicationResponse.success((String)"Succefully find all noticeboard", (Object)list);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while fetch all notice board" + e.getMessage()));
        }
    }

    public ApplicationResponse<?> findByNoticeBoardId(Long id) {
        try {
            Optional optional = this.noticeBoardDao.findById(id);
            if (optional.isPresent()) {
                NoticeBoardDto noticeBoardDto = this.mapToEntityDto((NoticeBoard)optional.get());
                return ApplicationResponse.success((String)"Successfully find noticeboard id", (Object)noticeBoardDto);
            }
            return ApplicationResponse.error((String)"Notice board not found");
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by notice board id" + e.getMessage()));
        }
    }

    private NoticeBoardDto mapToEntityDto(NoticeBoard noticeBoard) {
        return NoticeBoardDto.builder().id(noticeBoard.getId()).title(noticeBoard.getTitle()).description(noticeBoard.getDescription()).content(noticeBoard.getContent()).date(noticeBoard.getDate()).image(noticeBoard.getImage()).build();
    }

    public ApplicationResponse<NoticeBoard> deleteByNoticeBoardId(Long id) {
        try {
            Optional existNoticeBoard = this.noticeBoardDao.findById(id);
            if (existNoticeBoard.isEmpty()) {
                return ApplicationResponse.error((String)"Notice board not found");
            }
            this.noticeBoardDao.deleteByNoticeBoardId(id);
            return ApplicationResponse.success((String)"notice board id is delete successfully", null);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while deleted by notice board id" + e.getMessage()));
        }
    }
}

