/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.notice;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.notice.NoticeBoard;
import com.rugaa.NambaSchool.notice.NoticeBoardDto;
import com.rugaa.NambaSchool.notice.NoticeBoardService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/notice"})
public class NoticeBoardController {
    @Autowired
    private NoticeBoardService noticeBoardService;

    @PostMapping(value={"/save"})
    public ApplicationResponse<NoticeBoard> createNoticeBoard(@RequestBody NoticeBoardDto noticeBoardDto) {
        try {
            return this.noticeBoardService.createNoticeBoard(noticeBoardDto);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while create noticeboard" + e.getMessage()));
        }
    }

    @PostMapping(value={"/update"})
    public ApplicationResponse<NoticeBoard> upadteByNoticeBoardId(@RequestBody NoticeBoardDto noticeBoardDto, @RequestParam Long id) {
        try {
            return this.noticeBoardService.upadteByNoticeBoardId(noticeBoardDto, id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update noticeboard" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findall"})
    public ApplicationResponse<List<NoticeBoard>> fetchAll() {
        try {
            return this.noticeBoardService.fetchAll();
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while fetch all noticeboard" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findbyid"})
    public ApplicationResponse<?> findByNoticeBoardId(@RequestParam Long id) {
        try {
            return this.noticeBoardService.findByNoticeBoardId(id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by noticeboard id" + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/delete"})
    public ApplicationResponse<NoticeBoard> deleteByNoticeBoardId(@RequestParam Long id) {
        try {
            return this.noticeBoardService.deleteByNoticeBoardId(id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by noticeboard id" + e.getMessage()));
        }
    }
}

