/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.examTimetable;

import com.rugaa.NambaSchool.examTimetable.ExamTimeTableDto;
import com.rugaa.NambaSchool.exception.ValidationException;
import org.springframework.stereotype.Service;

@Service
public class ExamTimeTableValidation {
    public void validateRequest(ExamTimeTableDto examTimeTableDto) throws ValidationException {
        if (examTimeTableDto == null) {
            throw new ValidationException("examTimeTableDto cannot be null");
        }
        if (examTimeTableDto.getExamName() == null || examTimeTableDto.getExamName().trim().isEmpty()) {
            throw new ValidationException("Exam name is required");
        }
        if (examTimeTableDto.getStartDate() == null) {
            throw new ValidationException("Start date is required");
        }
        if (examTimeTableDto.getEndDate() == null) {
            throw new ValidationException("End date is required");
        }
        if (examTimeTableDto.getEndDate().isBefore(examTimeTableDto.getStartDate())) {
            throw new ValidationException("End date cannot be before start date");
        }
        if (examTimeTableDto.getStandard() == null || examTimeTableDto.getStandard().trim().isEmpty()) {
            throw new ValidationException("Standard is required");
        }
        if (examTimeTableDto.getSubjects() == null || examTimeTableDto.getSubjects().trim().isEmpty()) {
            throw new ValidationException("Subjects is required");
        }
        if (examTimeTableDto.getExamDate() == null) {
            throw new ValidationException("Exam date is required");
        }
        if (examTimeTableDto.getExamDate().isBefore(examTimeTableDto.getStartDate()) || examTimeTableDto.getExamDate().isAfter(examTimeTableDto.getEndDate())) {
            throw new ValidationException("Exam date must be within the start and end date range");
        }
        if (examTimeTableDto.getStartTime() == null) {
            throw new ValidationException("Start time is required");
        }
        if (examTimeTableDto.getEndTime() == null) {
            throw new ValidationException("End time is required");
        }
        if (examTimeTableDto.getEndTime().isBefore(examTimeTableDto.getStartTime())) {
            throw new ValidationException("End time cannot be before start time");
        }
        if (examTimeTableDto.getExamType() == null || examTimeTableDto.getExamType().trim().isEmpty()) {
            throw new ValidationException("Exam type cannot be null or empty");
        }
    }
}

