/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.examTimetable;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.examTimetable.ExamTimeTable;
import com.rugaa.NambaSchool.examTimetable.ExamTimeTableDao;
import com.rugaa.NambaSchool.examTimetable.ExamTimeTableDto;
import com.rugaa.NambaSchool.examTimetable.ExamTimeTableService;
import com.rugaa.NambaSchool.examTimetable.ExamTimeTableValidation;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ExamTimeTableServiceImpl
implements ExamTimeTableService {
    private final ExamTimeTableDao examTimeTableDao;
    private final ExamTimeTableValidation examTimeTableValidation;

    public ApplicationResponse<ExamTimeTable> createExamTimeTable(ExamTimeTableDto examTimeTableDto) {
        try {
            this.examTimeTableValidation.validateRequest(examTimeTableDto);
            ExamTimeTable examTimeTable = this.mapRequestToEmtity(examTimeTableDto);
            ExamTimeTable saveExamTimeTable = this.examTimeTableDao.createExamTimeTable(examTimeTable);
            return ApplicationResponse.success((String)"Succefully create examtime table", (Object)saveExamTimeTable);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while save examtimetable" + e.getMessage()));
        }
    }

    private ExamTimeTable mapRequestToEmtity(ExamTimeTableDto examTimeTableDto) {
        return ExamTimeTable.builder().examName(examTimeTableDto.getExamName()).startDate(examTimeTableDto.getStartDate()).endDate(examTimeTableDto.getEndDate()).standard(examTimeTableDto.getStandard()).subjects(examTimeTableDto.getSubjects()).examDate(examTimeTableDto.getExamDate()).startTime(examTimeTableDto.getStartTime()).endTime(examTimeTableDto.getEndTime()).examType(examTimeTableDto.getExamType()).build();
    }

    public ApplicationResponse<List<ExamTimeTable>> findAll() {
        try {
            List examTimeTables = this.examTimeTableDao.findAll();
            if (examTimeTables.isEmpty()) {
                return ApplicationResponse.error((String)"ExamTimeTable is not found");
            }
            return ApplicationResponse.success((String)"Successfuly find all ExamTimeTable", (Object)examTimeTables);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find all examtimetable" + e.getMessage()));
        }
    }

    public ApplicationResponse<?> findById(Long id) {
        try {
            Optional optional = this.examTimeTableDao.findById(id);
            if (optional.isPresent()) {
                ExamTimeTableDto examTimeTableDto = this.mapToEntityDto((ExamTimeTable)optional.get());
                return ApplicationResponse.success((String)"Successfully find examtimetable", (Object)examTimeTableDto);
            }
            return ApplicationResponse.error((String)"ExamTimeTable is not found");
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by examtimetable id" + e.getMessage()));
        }
    }

    private ExamTimeTableDto mapToEntityDto(ExamTimeTable examTimeTable) {
        return ExamTimeTableDto.builder().id(examTimeTable.getId()).examName(examTimeTable.getExamName()).startDate(examTimeTable.getStartDate()).endDate(examTimeTable.getEndDate()).standard(examTimeTable.getStandard()).subjects(examTimeTable.getSubjects()).examDate(examTimeTable.getExamDate()).startTime(examTimeTable.getStartTime()).endTime(examTimeTable.getEndTime()).examType(examTimeTable.getExamType()).build();
    }

    public ApplicationResponse<ExamTimeTable> updateById(Long id, ExamTimeTableDto examTimeTableDto) {
        try {
            Optional optional = this.examTimeTableDao.findById(id);
            ExamTimeTable examTimeTable = (ExamTimeTable)optional.get();
            this.updateRequestFromEntity(examTimeTable, examTimeTableDto);
            ExamTimeTable saveExamTimeTable = this.examTimeTableDao.createExamTimeTable(examTimeTable);
            return ApplicationResponse.success((String)"Successfully update examtimetable", (Object)saveExamTimeTable);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by examtimetable id" + e.getMessage()));
        }
    }

    private void updateRequestFromEntity(ExamTimeTable examTimeTable, ExamTimeTableDto examTimeTableDto) {
        if (examTimeTableDto.getExamName() != null) {
            examTimeTable.setExamName(examTimeTableDto.getExamName());
        }
        if (examTimeTableDto.getStartDate() != null) {
            examTimeTable.setStartDate(examTimeTableDto.getStartDate());
        }
        if (examTimeTableDto.getEndDate() != null) {
            examTimeTable.setEndDate(examTimeTableDto.getEndDate());
        }
        if (examTimeTableDto.getStandard() != null) {
            examTimeTable.setStandard(examTimeTableDto.getStandard());
        }
        if (examTimeTableDto.getSubjects() != null) {
            examTimeTable.setSubjects(examTimeTableDto.getSubjects());
        }
        if (examTimeTableDto.getStartTime() != null) {
            examTimeTable.setStartTime(examTimeTableDto.getStartTime());
        }
        if (examTimeTableDto.getEndTime() != null) {
            examTimeTable.setEndTime(examTimeTableDto.getEndTime());
        }
        if (examTimeTableDto.getExamDate() != null) {
            examTimeTable.setExamDate(examTimeTableDto.getExamDate());
        }
        if (examTimeTableDto.getExamType() != null) {
            examTimeTable.setExamType(examTimeTableDto.getExamType());
        }
    }

    public ApplicationResponse<ExamTimeTable> deleteById(Long id) {
        try {
            Optional existExamTimeTable = this.examTimeTableDao.findById(id);
            if (existExamTimeTable.isEmpty()) {
                return ApplicationResponse.error((String)"ExamTimeTable id is not found");
            }
            this.examTimeTableDao.deleteById(id);
            return ApplicationResponse.success((String)"Successfully delete ExamTimeTable id", null);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by examtimetable id" + e.getMessage()));
        }
    }

    @Generated
    public ExamTimeTableServiceImpl(ExamTimeTableDao examTimeTableDao, ExamTimeTableValidation examTimeTableValidation) {
        this.examTimeTableDao = examTimeTableDao;
        this.examTimeTableValidation = examTimeTableValidation;
    }
}

