/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.email;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.email.ZeptoMailConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import lombok.Generated;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EmailSender {
    private static final Logger logger = LoggerFactory.getLogger(EmailSender.class);
    private final ZeptoMailConfig zeptoMailConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationResponse<String> sendMailWithAttachment(String toMail, String body, String subject) {
        if (toMail == null || body == null || subject == null) {
            return ApplicationResponse.error((String)"Email address, body, and subject cannot be null.");
        }
        String postUrl = this.zeptoMailConfig.getApiUrl();
        HttpURLConnection conn = null;
        StringBuilder response = new StringBuilder();
        try {
            URL url = new URL(postUrl);
            conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Authorization", "Zoho-enczapikey " + this.zeptoMailConfig.getApiKey());
            JSONObject emailPayload = new JSONObject();
            emailPayload.put("from", (Object)new JSONObject().put("address", (Object)this.zeptoMailConfig.getFromEmail()));
            JSONArray recipients = new JSONArray();
            recipients.put((Object)new JSONObject().put("email_address", (Object)new JSONObject().put("address", (Object)toMail).put("name", (Object)"Recipient")));
            emailPayload.put("to", (Object)recipients);
            emailPayload.put("subject", (Object)subject);
            emailPayload.put("htmlbody", (Object)body);
            try (OutputStream os = conn.getOutputStream();){
                os.write(emailPayload.toString().getBytes());
                os.flush();
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                String line;
                while ((line = br.readLine()) != null) {
                    response.append(line);
                }
            }
            logger.info("Email sent successfully: {}", (Object)response);
            ApplicationResponse applicationResponse = ApplicationResponse.success((String)"Email sent successfully", (Object)response.toString());
            return applicationResponse;
        }
        catch (IOException e) {
            if (conn != null && conn.getErrorStream() != null) {
                try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getErrorStream()));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        response.append(line);
                    }
                }
                catch (IOException ex) {
                    logger.error("Error reading error stream", (Throwable)ex);
                }
            }
            logger.error("Failed to send email: {}", (Object)response);
            ApplicationResponse applicationResponse = ApplicationResponse.error((String)("Failed to send email: " + response.toString()));
            return applicationResponse;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public ApplicationResponse<String> sendOtpEmail(String recipientEmail, String otp) throws IOException {
        String subject = "Namba School OTP";
        String body = this.buildOtpEmailBody(otp);
        return this.sendMailWithAttachment(recipientEmail, body, subject);
    }

    public ApplicationResponse<String> sendForgotPasswordEmail(String recipientEmail, String otp) throws IOException {
        String subject = "Namba School Password Reset";
        String body = this.buildForgotPasswordEmailBody(otp);
        return this.sendMailWithAttachment(recipientEmail, body, subject);
    }

    public ApplicationResponse<String> sendRegistrationSuccessEmail(String recipientEmail, String userName, String registerid) throws IOException {
        String subject = "Welcome to Namba School";
        String body = this.buildRegistrationSuccessEmailBody(userName, registerid);
        return this.sendMailWithAttachment(recipientEmail, body, subject);
    }

    public ApplicationResponse<String> sendRegistrationEmail(String recipientEmail, String userName, String userEmail, String password) throws IOException {
        String subject = "Welcome to Namba School";
        String body = this.buildCredentialDetailsEmailBody(userName, userEmail, password);
        return this.sendMailWithAttachment(recipientEmail, body, subject);
    }

    public String buildOtpEmailBody(String otp) {
        return "<html><p>Welcome to Namba School! To complete your account setup, please use the OTP below:</p><p><strong>Your OTP: " + otp + "</strong></p><p>This OTP is valid for the next 10 minutes. Please enter it on the registration page to verify your email address.</p><p>If you did not request an account with Namba School, please ignore this email.</p><br><p>Best regards,</p><p>The Namba School Team</p><p><a href='mailto:support@nambaschool.com'>support@nambaschool.com</a></p><p><a href='https://www.nambaschool.com'>www.nambaschool.com</a></p></html>";
    }

    public String buildForgotPasswordEmailBody(String otp) {
        return "<html><p>Hi,</p><p>We received a request to reset your password. Please use the OTP below to reset your password:</p><p><strong>Your OTP: " + otp + "</strong></p><p>This OTP is valid for the next 10 minutes. Please enter it to reset your password.</p><p>If you did not request a password reset, please ignore this email.</p><p>Best regards,</p><p>The Namba School Team</p><p><a href='mailto:support@nambaschool.com'>support@nambaschool.com</a></p><p><a href='https://www.nambaschool.com'>www.nambaschool.com</a></p></html>";
    }

    public String buildRegistrationSuccessEmailBody(String userName, String registerid) {
        return "<html><p>Hello " + userName + ",</p><p>Registration id: " + registerid + "</p><p>Welcome to Namba School! We're excited to have you on board. Your account is now active, and you can log in to your dashboard.</p><p>If you have any questions, feel free to reach out to us at <a href='mailto:support@nambaschool.com'>support@nambaschool.com</a>.</p><p>Best regards,</p><p>The Namba School Team</p><p><a href='https://www.nambaschool.com'>www.nambaschool.com</a></p></html>";
    }

    public String buildCredentialDetailsEmailBody(String userName, String userEmail, String password) {
        return "<html><p>Hello " + userName + ",</p><p>Welcome to Namba School! Below are your account credentials:</p><p>UserName: " + userEmail + "</p><p>Password: " + password + "</p><p>We recommend changing your password after your first login.</p><p>If you have any questions, feel free to reach out to us at <a href='mailto:support@nambaschool.com'>support@nambaschool.com</a>.</p><p>Best regards,</p><p>The Namba School Team</p><p><a href='https://www.nambaschool.com'>www.nambaschool.com</a></p></html>";
    }

    @Generated
    public EmailSender(ZeptoMailConfig zeptoMailConfig) {
        this.zeptoMailConfig = zeptoMailConfig;
    }
}

