/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.classResultReport;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.classResultReport.ClassResult;
import com.rugaa.NambaSchool.classResultReport.ClassResultDao;
import com.rugaa.NambaSchool.classResultReport.ClassResultDto;
import com.rugaa.NambaSchool.classResultReport.ClassResultService;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.data.crossstore.ChangeSetPersister;
import org.springframework.stereotype.Service;

@Service
public class ClassResultServiceImpl
implements ClassResultService {
    private final ClassResultDao classResultDao;

    public ApplicationResponse<ClassResult> createClassResult(ClassResultDto classResultDto) {
        try {
            ClassResult classResult = this.mapRequestToEntity(classResultDto);
            Long marks = classResult.getTamil() + classResult.getEnglish() + classResult.getMaths() + classResult.getScience() + classResult.getSocialScience();
            classResult.setTotalMarks(marks);
            Double percentage = (double)marks.longValue() / 5.0;
            classResult.setPercentage(percentage);
            String grade = this.assignGrade(percentage);
            classResult.setGrade(grade);
            String passOrFail = this.mapToPassOrFail(classResult);
            classResult.setPassORfail(passOrFail);
            ClassResult savedClassResult = this.classResultDao.createClassResult(classResult);
            return ApplicationResponse.success((String)"Successfully created Class Result", (Object)savedClassResult);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while creating Class Result: " + e.getMessage()));
        }
    }

    private String mapToPassOrFail(ClassResult classMarks) {
        if (classMarks.getTamil() < 35L || classMarks.getEnglish() < 35L || classMarks.getMaths() < 35L || classMarks.getScience() < 35L || classMarks.getSocialScience() < 35L) {
            return "Fail";
        }
        return "Pass";
    }

    private String assignGrade(Double percentage) {
        if (percentage >= 90.0) {
            return "A+";
        }
        if (percentage >= 80.0) {
            return "A";
        }
        if (percentage >= 70.0) {
            return "B";
        }
        if (percentage >= 60.0) {
            return "C";
        }
        if (percentage >= 50.0) {
            return "D";
        }
        return "F";
    }

    private ClassResult mapRequestToEntity(ClassResultDto classResultDto) {
        return ClassResult.builder().studentName(classResultDto.getStudentName()).rollNumber(classResultDto.getRollNumber()).section(classResultDto.getSection()).studentRank(classResultDto.getStudentRank()).tamil(classResultDto.getTamil()).english(classResultDto.getEnglish()).maths(classResultDto.getMaths()).science(classResultDto.getScience()).socialScience(classResultDto.getSocialScience()).build();
    }

    public ApplicationResponse<List<ClassResult>> findAll() {
        try {
            List classResults = this.classResultDao.findAll();
            if (classResults.isEmpty()) {
                return ApplicationResponse.error((String)"ClassResult is not found");
            }
            return ApplicationResponse.success((String)"Successfully find all class Result", (Object)classResults);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find all Class Result: " + e.getMessage()));
        }
    }

    public ApplicationResponse<?> findById(Long id) {
        try {
            Optional optional = this.classResultDao.findById(id);
            if (optional.isPresent()) {
                ClassResultDto classResultDto = this.mapToEntityDto((ClassResult)optional.get());
                return ApplicationResponse.success((String)"Successfully find class result", (Object)classResultDto);
            }
            return ApplicationResponse.error((String)"ClassResult is not found");
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by Class Result id: " + e.getMessage()));
        }
    }

    private ClassResultDto mapToEntityDto(ClassResult classResult) {
        return ClassResultDto.builder().id(classResult.getId()).studentName(classResult.getStudentName()).rollNumber(classResult.getRollNumber()).section(classResult.getSection()).studentRank(classResult.getStudentRank()).tamil(classResult.getTamil()).english(classResult.getEnglish()).maths(classResult.getMaths()).science(classResult.getScience()).socialScience(classResult.getSocialScience()).build();
    }

    public ApplicationResponse<ClassResult> updateById(Long id, ClassResultDto classResultDto) {
        try {
            Optional optional = this.classResultDao.findById(id);
            ClassResult classResult = (ClassResult)optional.get();
            this.updateRequestFromEntity(classResult, classResultDto);
            ClassResult saveClassResult = this.classResultDao.createClassResult(classResult);
            return ApplicationResponse.success((String)"Successfully update Class Result", (Object)saveClassResult);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by Class Result id: " + e.getMessage()));
        }
    }

    private void updateRequestFromEntity(ClassResult classResult, ClassResultDto classResultDto) {
        if (classResultDto.getStudentName() != null) {
            classResult.setStudentName(classResultDto.getStudentName());
        }
        if (classResultDto.getRollNumber() != null) {
            classResult.setRollNumber(classResultDto.getRollNumber());
        }
        if (classResultDto.getSection() != null) {
            classResult.setSection(classResultDto.getSection());
        }
        if (classResultDto.getStudentRank() != null) {
            classResult.setStudentName(classResultDto.getStudentName());
        }
        if (classResultDto.getStudentName() != null) {
            classResult.setStudentRank(classResultDto.getStudentRank());
        }
        if (classResultDto.getTamil() != null) {
            classResult.setTamil(classResultDto.getTamil());
        }
        if (classResultDto.getEnglish() != null) {
            classResult.setEnglish(classResultDto.getEnglish());
        }
        if (classResultDto.getMaths() != null) {
            classResult.setMaths(classResultDto.getMaths());
        }
        if (classResultDto.getScience() != null) {
            classResult.setScience(classResultDto.getScience());
        }
        if (classResultDto.getSocialScience() != null) {
            classResult.setSocialScience(classResultDto.getSocialScience());
        }
    }

    public ApplicationResponse<ClassResult> deleteById(Long id) {
        try {
            Optional existClassResult = this.classResultDao.findById(id);
            if (existClassResult.isEmpty()) {
                return ApplicationResponse.error((String)"ClassResult id is not found");
            }
            this.classResultDao.deleteById(id);
            return ApplicationResponse.success((String)"Successfully deleted ClassResult id", null);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by Class Result id: " + e.getMessage()));
        }
    }

    public ApplicationResponse<?> findByStudentName(String studentName) {
        try {
            Optional optional = this.classResultDao.findByStudentName(studentName);
            if (optional.isPresent()) {
                return ApplicationResponse.success((String)"Successfully find StudentName", (Object)optional);
            }
            return ApplicationResponse.error((String)"StudentName is not found");
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while findByStudentName in Class Result: " + e.getMessage()));
        }
    }

    public ApplicationResponse<?> findByRollNumber(String rollNumber) {
        try {
            ClassResult classResult = (ClassResult)this.classResultDao.findByRollNumber(rollNumber).orElseThrow(() -> new ChangeSetPersister.NotFoundException());
            return ApplicationResponse.success((String)"Successfully found RollNumber", (Object)classResult);
        }
        catch (ChangeSetPersister.NotFoundException e) {
            return ApplicationResponse.error((String)e.getMessage());
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while findByRollNumber in Class Result: " + e.getMessage()));
        }
    }

    @Generated
    public ClassResultServiceImpl(ClassResultDao classResultDao) {
        this.classResultDao = classResultDao;
    }
}

