/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.classResult;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.classResult.ExamResult;
import com.rugaa.NambaSchool.classResult.ExamResultDao;
import com.rugaa.NambaSchool.classResult.ExamResultDto;
import com.rugaa.NambaSchool.classResult.ExamResultService;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ExamResultServiceImpl
implements ExamResultService {
    private final ExamResultDao examResultDao;

    public ApplicationResponse<ExamResult> createExamResult(ExamResultDto examResultDto) {
        try {
            ExamResult examResult = this.mapRequestToDto(examResultDto);
            ExamResult saveExamResult = this.examResultDao.createExamResult(examResult);
            return ApplicationResponse.success((String)"Successfully create ExamResult", (Object)saveExamResult);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while ExamResult" + e.getMessage()));
        }
    }

    private ExamResult mapRequestToDto(ExamResultDto examResultDto) {
        return ExamResult.builder().examName(examResultDto.getExamName()).section(examResultDto.getSection()).standard(examResultDto.getStandard()).details(examResultDto.getDetails()).build();
    }

    public ApplicationResponse<List<ExamResult>> findAll() {
        try {
            List examResults = this.examResultDao.findAll();
            if (examResults.isEmpty()) {
                return ApplicationResponse.error((String)"Exam result is not found");
            }
            return ApplicationResponse.success((String)"Succefully find all Exam result", (Object)examResults);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find all ExamResult" + e.getMessage()));
        }
    }

    public ApplicationResponse<?> findById(Long id) {
        try {
            Optional optional = this.examResultDao.findById(id);
            if (optional.isPresent()) {
                ExamResultDto examResultDto = this.mapToEntityDto((ExamResult)optional.get());
                return ApplicationResponse.success((String)"Succefully find Examresult", (Object)examResultDto);
            }
            return ApplicationResponse.error((String)"Exam result is not found");
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by ExamResult id" + e.getMessage()));
        }
    }

    private ExamResultDto mapToEntityDto(ExamResult examResult) {
        return ExamResultDto.builder().id(examResult.getId()).examName(examResult.getExamName()).section(examResult.getSection()).standard(examResult.getStandard()).details(examResult.getDetails()).build();
    }

    public ApplicationResponse<ExamResult> updateById(ExamResultDto examResultDto, Long id) {
        try {
            Optional optional = this.examResultDao.findById(id);
            ExamResult examResult = (ExamResult)optional.get();
            this.updateRequestFromEntity(examResult, examResultDto);
            ExamResult saveExamResult = this.examResultDao.createExamResult(examResult);
            return ApplicationResponse.success((String)"Successfully update Exam result", (Object)saveExamResult);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by ExamResult id" + e.getMessage()));
        }
    }

    private void updateRequestFromEntity(ExamResult examResult, ExamResultDto examResultDto) {
        if (examResultDto.getExamName() != null) {
            examResult.setExamName(examResultDto.getExamName());
        }
        if (examResultDto.getSection() != null) {
            examResult.setSection(examResultDto.getSection());
        }
        if (examResultDto.getStandard() != null) {
            examResult.setStandard(examResultDto.getStandard());
        }
        if (examResultDto.getDetails() != null) {
            examResult.setDetails(examResultDto.getDetails());
        }
    }

    public ApplicationResponse<ExamResult> deleteById(Long id) {
        try {
            Optional existExamResult = this.examResultDao.findById(id);
            if (existExamResult.isEmpty()) {
                return ApplicationResponse.error((String)"Exam result id is not found");
            }
            this.examResultDao.deleteById(id);
            return ApplicationResponse.success((String)"Successfully delete Exam result", null);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by ExamResult id" + e.getMessage()));
        }
    }

    @Generated
    public ExamResultServiceImpl(ExamResultDao examResultDao) {
        this.examResultDao = examResultDao;
    }
}

