/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.classManagement;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.classManagement.ClassRoom;
import com.rugaa.NambaSchool.classManagement.ClassRoomDao;
import com.rugaa.NambaSchool.classManagement.ClassRoomDto;
import com.rugaa.NambaSchool.classManagement.ClassRoomService;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ClassRoomServiceImpl
implements ClassRoomService {
    private final ClassRoomDao classRoomDao;

    public ApplicationResponse<ClassRoom> createClassRoom(ClassRoomDto classRoomDto) {
        try {
            ClassRoom classRoom = this.mapRequestToEntity(classRoomDto);
            ClassRoom savaClassRoom = this.classRoomDao.createClassRoom(classRoom);
            return ApplicationResponse.success((String)"Successfully createClassRoom", (Object)savaClassRoom);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while createClassRoom" + e.getMessage()));
        }
    }

    private ClassRoom mapRequestToEntity(ClassRoomDto classRoomDto) {
        return ClassRoom.builder().section(classRoomDto.getSection()).standard(classRoomDto.getStandard()).studentId(classRoomDto.getStudentId()).teacherId(classRoomDto.getTeacherId()).build();
    }

    public ApplicationResponse<List<ClassRoom>> findall() {
        try {
            List list = this.classRoomDao.findall();
            if (list.isEmpty()) {
                return ApplicationResponse.error((String)"ClassRoom is not found");
            }
            return ApplicationResponse.success((String)"Successfully findall ClassRoom", (Object)list);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while findall ClassRoom" + e.getMessage()));
        }
    }

    public ApplicationResponse<?> findById(Long id) {
        try {
            Optional optional = this.classRoomDao.findById(id);
            if (optional.isPresent()) {
                ClassRoomDto classRoomDto = this.mapToEntityDto((ClassRoom)optional.get());
                return ApplicationResponse.success((String)"Successfully findBy ClassRoom id", (Object)classRoomDto);
            }
            return ApplicationResponse.error((String)"ClassRoom is not found");
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by ClassRoom id" + e.getMessage()));
        }
    }

    private ClassRoomDto mapToEntityDto(ClassRoom classRoom) {
        return ClassRoomDto.builder().id(classRoom.getId()).section(classRoom.getSection()).standard(classRoom.getStandard()).studentId(classRoom.getStudentId()).teacherId(classRoom.getTeacherId()).build();
    }

    public ApplicationResponse<ClassRoom> updateById(ClassRoomDto classRoomDto, Long id) {
        try {
            Optional optional = this.classRoomDao.findById(id);
            ClassRoom classRoom = (ClassRoom)optional.get();
            this.updateRequestFromEntity(classRoom, classRoomDto);
            ClassRoom saveClassRoom = this.classRoomDao.createClassRoom(classRoom);
            return ApplicationResponse.success((String)"Successfully update by ClassRoom id", (Object)saveClassRoom);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by ClassRoom id" + e.getMessage()));
        }
    }

    private void updateRequestFromEntity(ClassRoom classRoom, ClassRoomDto classRoomDto) {
        if (classRoomDto.getSection() != null) {
            classRoom.setSection(classRoomDto.getSection());
        }
        if (classRoomDto.getStandard() != null) {
            classRoom.setStandard(classRoomDto.getStandard());
        }
        if (classRoomDto.getStudentId() != null) {
            classRoom.setStudentId(classRoomDto.getStudentId());
        }
        if (classRoomDto.getTeacherId() != null) {
            classRoom.setTeacherId(classRoomDto.getTeacherId());
        }
    }

    public ApplicationResponse<ClassRoom> deleteById(Long id) {
        try {
            Optional existClassRoom = this.classRoomDao.findById(id);
            if (existClassRoom.isEmpty()) {
                return ApplicationResponse.error((String)"ClassRoom id is not found");
            }
            this.classRoomDao.deleteById(id);
            return ApplicationResponse.success((String)"Successfully delete by ClassRoom id", null);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by ClassRoom id" + e.getMessage()));
        }
    }

    @Generated
    public ClassRoomServiceImpl(ClassRoomDao classRoomDao) {
        this.classRoomDao = classRoomDao;
    }
}

