/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.authentication;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.authentication.AuthenticationResponse;
import com.rugaa.NambaSchool.authentication.AuthenticationService;
import com.rugaa.NambaSchool.authentication.RegisterRequest;
import com.rugaa.NambaSchool.authentication.UserResponse;
import com.rugaa.NambaSchool.password.PasswordChangeRequest;
import com.rugaa.NambaSchool.security.JwtService;
import com.rugaa.NambaSchool.user.Role;
import com.rugaa.NambaSchool.user.User;
import com.rugaa.NambaSchool.user.UserDao;
import java.util.Base64;
import java.util.Optional;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class AuthenticationServiceImpl
implements AuthenticationService {
    @Autowired
    private JwtService jwtService;
    @Autowired
    private PasswordEncoder encoder;
    @Autowired
    private UserDao userDao;
    @Autowired
    private AuthenticationManager authenticationManager;

    public ApplicationResponse<AuthenticationResponse> register(RegisterRequest request) {
        User user = User.builder().firstname(request.getFirstname()).contactperson(request.getContactperson()).email(request.getEmail()).mobile(request.getMobile()).status(Boolean.valueOf(true)).password(this.encoder.encode((CharSequence)request.getPassword())).role(Role.ADMIN).build();
        this.userDao.save(user);
        String jwtToken = this.jwtService.generateToken((UserDetails)user);
        AuthenticationResponse authResponse = AuthenticationResponse.builder().token(jwtToken).build();
        return ApplicationResponse.success((String)"User registered successfully", (Object)authResponse);
    }

    public ApplicationResponse<AuthenticationResponse> authenticate(RegisterRequest request) {
        try {
            User user = null;
            if (request.getEmail() != null && !request.getEmail().isEmpty()) {
                if (request.getEmail().contains("@") || request.getEmail().contains("admin")) {
                    user = (User)this.userDao.findByEmail(request.getEmail()).orElseThrow(() -> new UsernameNotFoundException("User not found with email: " + request.getEmail()));
                } else {
                    user = this.userDao.findByLoginCode(request.getEmail()).orElse(null);
                    if (user == null) {
                        return ApplicationResponse.error((String)("User not found with loginCode: " + request.getEmail()));
                    }
                    if (user.getEmail() == null || user.getEmail().isEmpty()) {
                        return ApplicationResponse.error((String)"User found with empcode but no email available for authentication.");
                    }
                }
                if (user.getStatus() == null || !user.getStatus().booleanValue()) {
                    return ApplicationResponse.error((String)"User account is inactive.");
                }
                this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)user.getEmail(), (Object)request.getPassword()));
                String jwtToken = this.jwtService.generateToken((UserDetails)user);
                AuthenticationResponse authResponse = AuthenticationResponse.builder().token(jwtToken).build();
                return ApplicationResponse.success((String)"Authentication successful", (Object)authResponse);
            }
            return ApplicationResponse.error((String)"Invalid login request: no identifier provided");
        }
        catch (UsernameNotFoundException ex) {
            return ApplicationResponse.error((String)("Authentication failed: " + ex.getMessage()));
        }
        catch (BadCredentialsException ex) {
            return ApplicationResponse.error((String)"Authentication failed: invalid credentials");
        }
        catch (IllegalStateException ex) {
            return ApplicationResponse.error((String)("Authentication failed: " + ex.getMessage()));
        }
        catch (Exception ex) {
            return ApplicationResponse.error((String)("An unexpected error occurred during authentication: " + ex.getMessage()));
        }
    }

    public ApplicationResponse<AuthenticationResponse> authentication(RegisterRequest request) {
        try {
            User user = null;
            if (request.getEmail() != null && !request.getEmail().isEmpty()) {
                if (request.getEmail().contains("@") || request.getEmail().contains("admin")) {
                    user = (User)this.userDao.findByEmail(request.getEmail()).orElseThrow(() -> new UsernameNotFoundException("User not found with email: " + request.getEmail()));
                } else {
                    user = this.userDao.findByLoginCode(request.getEmail()).orElse(null);
                    if (user == null) {
                        return ApplicationResponse.error((String)("User not found with empcode: " + request.getEmail()));
                    }
                    if (user.getEmail() == null || user.getEmail().isEmpty()) {
                        return ApplicationResponse.error((String)"User found with empcode but no email available for authentication.");
                    }
                }
                if (user.getStatus() == null || !user.getStatus().booleanValue()) {
                    return ApplicationResponse.error((String)"User account is inactive.");
                }
                this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)user.getEmail(), (Object)request.getPassword()));
                String jwtToken = this.jwtService.generateToken((UserDetails)user);
                AuthenticationResponse authResponse = AuthenticationResponse.builder().token(jwtToken).build();
                return ApplicationResponse.success((String)"Authentication successful", (Object)authResponse);
            }
            return ApplicationResponse.error((String)"Invalid login request: no identifier provided");
        }
        catch (UsernameNotFoundException ex) {
            return ApplicationResponse.error((String)("Authentication failed: " + ex.getMessage()));
        }
        catch (BadCredentialsException ex) {
            return ApplicationResponse.error((String)"Authentication failed: invalid credentials");
        }
        catch (IllegalStateException ex) {
            return ApplicationResponse.error((String)("Authentication failed: " + ex.getMessage()));
        }
        catch (Exception ex) {
            return ApplicationResponse.error((String)("An unexpected error occurred during authentication: " + ex.getMessage()));
        }
    }

    public ApplicationResponse<UserResponse> getDetails(String aS) {
        try {
            String bearer = aS.substring(aS.indexOf(".") + 1);
            String bearer1 = bearer.substring(0, bearer.indexOf("."));
            Base64.Decoder decoder = Base64.getUrlDecoder();
            String token = new String(decoder.decode(bearer1));
            JSONObject jsonObject = new JSONObject(token);
            String userName = jsonObject.getString("sub");
            Optional creator = this.userDao.findByEmail(userName);
            if (creator.isPresent()) {
                User user = (User)creator.get();
                UserResponse res = new UserResponse();
                res.setEmail(user.getEmail());
                res.setFirstname(user.getFirstname());
                res.setContactperson(user.getContactperson());
                res.setId(user.getId());
                res.setMobile(user.getMobile());
                res.setRole(user.getRole());
                res.setApproved(user.getApproved());
                res.setSchoolid(user.getSchoolid());
                res.setSchoolregistration(user.getSchoolregistration());
                res.setAcademicyear(user.getAcademicyear());
                return ApplicationResponse.success((String)"User details retrieved successfully", (Object)res);
            }
            return ApplicationResponse.error((String)"Error: User not found.");
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("Error processing request: " + e.getMessage()));
        }
    }

    public PasswordChangeRequest getPassDetails(String as) {
        String bearer = as.substring(as.indexOf("."), 1);
        String bearers = bearer.substring(0, bearer.indexOf("."));
        Base64.Decoder decoder = Base64.getUrlDecoder();
        String token = new String(decoder.decode(bearers));
        JSONObject jsonObject = new JSONObject(token);
        String userName = jsonObject.getString("sub");
        Optional creator = this.userDao.findByEmail(userName);
        if (creator.isPresent()) {
            PasswordChangeRequest res = new PasswordChangeRequest();
            User user = (User)creator.get();
            res.setOldPassword(user.getPassword());
            return res;
        }
        throw new RuntimeException("Error: User not found");
    }

    public ApplicationResponse<Optional<User>> checkEmail(String email) {
        try {
            Optional optional = this.userDao.findByEmail(email);
            if (optional.isPresent()) {
                return ApplicationResponse.error((String)"Email Id is already present");
            }
            return ApplicationResponse.success((String)"Email ID is available", (Object)optional);
        }
        catch (Exception e) {
            throw new RuntimeException("Error: Email not found");
        }
    }

    public ApplicationResponse<Optional<User>> checkMobile(Long mobile) {
        try {
            Optional optional = this.userDao.findByMobile(mobile);
            if (optional.isPresent()) {
                return ApplicationResponse.error((String)"Mobile number is already present");
            }
            return ApplicationResponse.success((String)"Mobile number is available", (Object)optional);
        }
        catch (Exception e) {
            throw new RuntimeException("Error: mobile number not found");
        }
    }

    public UserResponse getTokenDetails(String aS) {
        try {
            if (aS == null || !aS.contains(".")) {
                throw new IllegalArgumentException("Invalid token format");
            }
            String bearer = aS.substring(aS.indexOf(".") + 1);
            String bearer1 = bearer.substring(0, bearer.indexOf("."));
            Base64.Decoder decoder = Base64.getUrlDecoder();
            String token = new String(decoder.decode(bearer1));
            JSONObject jsonObject = new JSONObject(token);
            if (!jsonObject.has("sub")) {
                throw new IllegalArgumentException("Token does not contain 'sub' field");
            }
            String userName = jsonObject.getString("sub");
            User user = (User)this.userDao.findByEmail(userName).orElseThrow(() -> new IllegalArgumentException("User not found for email: " + userName));
            UserResponse res = new UserResponse();
            res.setEmail(user.getEmail());
            res.setFirstname(user.getFirstname());
            res.setContactperson(user.getContactperson());
            res.setId(user.getId());
            res.setMobile(user.getMobile());
            res.setRole(user.getRole());
            res.setSchoolid(user.getSchoolid());
            res.setSchoolregistration(user.getSchoolregistration());
            res.setAcademicyear(user.getAcademicyear());
            return res;
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Error processing token: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error occurred while processing token", e);
        }
    }
}

