/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.academics;

import com.rugaa.NambaSchool.academics.AcademicYear;
import com.rugaa.NambaSchool.academics.AcademicYearDao;
import com.rugaa.NambaSchool.academics.AcademicYearDto;
import com.rugaa.NambaSchool.academics.AcademicYearMapper;
import com.rugaa.NambaSchool.academics.AcademicYearService;
import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class AcademicYearServiceImpl
implements AcademicYearService {
    private final AcademicYearDao academicYearDao;
    private final AcademicYearMapper academicYearMapper;

    public ApplicationResponse<AcademicYear> createAcademicYear(AcademicYearDto academicYearDto) {
        try {
            AcademicYear academicYear = this.academicYearMapper.mapRequestToEntity(academicYearDto);
            int startYear = academicYear.getStartDate().getYear();
            int endYear = academicYear.getEndDate().getYear();
            academicYear.setName(startYear + "-" + endYear);
            AcademicYear saveAcademicYear = this.academicYearDao.createAcademicYear(academicYear);
            return ApplicationResponse.success((String)"Successfully create AcademicYear", (Object)saveAcademicYear);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while createAcademicYear" + e.getMessage()));
        }
    }

    public ApplicationResponse<List<AcademicYearDto>> findAll() {
        try {
            List academicYears = this.academicYearDao.findAll();
            if (academicYears.isEmpty()) {
                return ApplicationResponse.error((String)"AcademicYear not found");
            }
            List academicYearDtos = academicYears.stream().map(arg_0 -> ((AcademicYearMapper)this.academicYearMapper).mapEntityToDto(arg_0)).collect(Collectors.toList());
            return ApplicationResponse.success((String)"Successfully find all AcademicYear", academicYearDtos);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while get all AcademicYear" + e.getMessage()));
        }
    }

    public ApplicationResponse<AcademicYearDto> findById(Long id) {
        try {
            Optional optional = this.academicYearDao.findById(id);
            if (optional.isPresent()) {
                AcademicYearDto academicYearDto = this.academicYearMapper.mapEntityToDto((AcademicYear)optional.get());
                return ApplicationResponse.success((String)"Successfully find AcademicYear id", (Object)academicYearDto);
            }
            return ApplicationResponse.error((String)"AcademicYear id is not find");
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by AcademicYear id" + e.getMessage()));
        }
    }

    public ApplicationResponse<AcademicYear> updateById(Long id, AcademicYearDto academicYearDto) {
        try {
            Optional stuOptional = this.academicYearDao.findById(id);
            AcademicYear academicYear = (AcademicYear)stuOptional.get();
            this.academicYearMapper.updateRequestFromEntity(academicYear, academicYearDto);
            AcademicYear saveAcademicYear = this.academicYearDao.updateByStudentId(academicYear);
            return ApplicationResponse.success((String)"Successfully update AcademicYear id", (Object)saveAcademicYear);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by AcademicYear id" + e.getMessage()));
        }
    }

    public ApplicationResponse<AcademicYear> deleteById(Long id) {
        try {
            Optional existAcademicYear = this.academicYearDao.findById(id);
            if (existAcademicYear.isEmpty()) {
                return ApplicationResponse.error((String)"AcademicYear id is not found");
            }
            this.academicYearDao.deleteById(id);
            return ApplicationResponse.success((String)"AcademicYear id is delete successfully", null);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by AcademicYear id" + e.getMessage()));
        }
    }

    @Generated
    public AcademicYearServiceImpl(AcademicYearDao academicYearDao, AcademicYearMapper academicYearMapper) {
        this.academicYearDao = academicYearDao;
        this.academicYearMapper = academicYearMapper;
    }
}

