/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.MainService;

import com.rugaa.NambaSchool.ClassEntity.ClassEntity;
import com.rugaa.NambaSchool.ClassEntity.ClassEntityDao;
import com.rugaa.NambaSchool.MAIN.AcademicClass;
import com.rugaa.NambaSchool.MAIN.SectionAssignment;
import com.rugaa.NambaSchool.MainDao.AcademicClassDao;
import com.rugaa.NambaSchool.MainDao.SectionAssignmentDao;
import com.rugaa.NambaSchool.MainDao.StudentAssignmentDao;
import com.rugaa.NambaSchool.MainDao.SubjectAssignmentDao;
import com.rugaa.NambaSchool.MainDao.SubjectTeacherAssignmentDao;
import com.rugaa.NambaSchool.MainDto.AcademicClassDTO;
import com.rugaa.NambaSchool.MainService.AcademicClassMapper;
import com.rugaa.NambaSchool.MainService.AcademicClassService;
import com.rugaa.NambaSchool.academics.AcademicYear;
import com.rugaa.NambaSchool.academics.AcademicYearDao;
import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.sections.Sections;
import com.rugaa.NambaSchool.sections.SectionsDao;
import com.rugaa.NambaSchool.studentRegister.StudentDao;
import com.rugaa.NambaSchool.subjects.SubjectDao;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class AcademicClassServiceImpl
implements AcademicClassService {
    private final AcademicYearDao academicYearDao;
    private final AcademicClassDao academicClassDao;
    private final ClassEntityDao classEntityDao;
    private final SectionsDao sectionsDao;
    private final SubjectDao subjectDao;
    private final StudentDao studentDao;
    private final SubjectTeacherAssignmentDao subjectTeacherAssignmentDao;
    private final StudentAssignmentDao studentAssignmentDao;
    private final SubjectAssignmentDao subjectAssignmentDao;
    private final SectionAssignmentDao sectionAssignmentDao;
    private final AcademicClassMapper academicClassMapper;

    public ApplicationResponse<Long> createAcademicClass(AcademicClassDTO dto) {
        try {
            AcademicYear academicYear = (AcademicYear)this.academicYearDao.findById(dto.getAcademicYearId()).orElseThrow(() -> new RuntimeException("Academic Year not found"));
            ClassEntity classEntity = (ClassEntity)this.classEntityDao.findById(dto.getClassEntityId()).orElseThrow(() -> new RuntimeException("Class not found"));
            AcademicClass academicClass = new AcademicClass();
            academicClass.setAcademicYear(academicYear);
            academicClass.setClassEntity(classEntity);
            ArrayList<SectionAssignment> assignments = new ArrayList<SectionAssignment>();
            if (dto.getSectionIds() != null) {
                for (Long sectionId : dto.getSectionIds()) {
                    Sections section = (Sections)this.sectionsDao.findById(sectionId).orElseThrow(() -> new RuntimeException("Section not found: " + sectionId));
                    SectionAssignment assignment = new SectionAssignment();
                    assignment.setSection(section);
                    assignment.setAcademicClass(academicClass);
                    assignments.add(assignment);
                }
            }
            academicClass.setSections(assignments);
            academicClass = this.academicClassDao.saveAcademicClass(academicClass);
            return ApplicationResponse.success((String)"Academic class with sections created", (Object)academicClass.getId());
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("Failed to create academic class: " + e.getMessage()));
        }
    }

    public ApplicationResponse<Long> updateAcademicClass(Long id, AcademicClassDTO dto) {
        try {
            AcademicClass academicClass = (AcademicClass)this.academicClassDao.findById(id).orElseThrow(() -> new RuntimeException("Academic Class not found"));
            AcademicYear academicYear = (AcademicYear)this.academicYearDao.findById(dto.getAcademicYearId()).orElseThrow(() -> new RuntimeException("Academic Year not found"));
            ClassEntity classEntity = (ClassEntity)this.classEntityDao.findById(dto.getClassEntityId()).orElseThrow(() -> new RuntimeException("Class not found"));
            ArrayList sections = dto.getSectionIds() != null ? dto.getSectionIds().stream().map(idVal -> (Sections)this.sectionsDao.findById(idVal).orElseThrow(() -> new RuntimeException("Section not found: " + idVal))).collect(Collectors.toList()) : new ArrayList();
            this.academicClassMapper.updateEntityFromDto(academicClass, dto, academicYear, classEntity, sections);
            this.academicClassDao.saveAcademicClass(academicClass);
            return ApplicationResponse.success((String)"Academic class updated", (Object)academicClass.getId());
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("Failed to update academic class: " + e.getMessage()));
        }
    }

    public ApplicationResponse<String> deleteAcademicClass(Long id) {
        try {
            AcademicClass academicClass = (AcademicClass)this.academicClassDao.findById(id).orElseThrow(() -> new RuntimeException("Academic Class not found"));
            this.academicClassDao.delete(academicClass);
            return ApplicationResponse.success((String)"Academic class deleted", (Object)("Deleted ID: " + id));
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("Failed to delete academic class: " + e.getMessage()));
        }
    }

    public ApplicationResponse<AcademicClassDTO> findAcademicClassById(Long id) {
        try {
            AcademicClass academicClass = (AcademicClass)this.academicClassDao.findById(id).orElseThrow(() -> new RuntimeException("Academic Class not found"));
            AcademicClassDTO dto = this.academicClassMapper.toDto(academicClass);
            return ApplicationResponse.success((String)"Academic class found", (Object)dto);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("Failed to find academic class: " + e.getMessage()));
        }
    }

    public ApplicationResponse<List<AcademicClassDTO>> findAllAcademicClasses() {
        try {
            List classes = this.academicClassDao.findAll();
            List dtos = classes.stream().map(arg_0 -> ((AcademicClassMapper)this.academicClassMapper).toDto(arg_0)).collect(Collectors.toList());
            return ApplicationResponse.success((String)"Academic classes retrieved", dtos);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("Failed to retrieve academic classes: " + e.getMessage()));
        }
    }

    @Generated
    public AcademicClassServiceImpl(AcademicYearDao academicYearDao, AcademicClassDao academicClassDao, ClassEntityDao classEntityDao, SectionsDao sectionsDao, SubjectDao subjectDao, StudentDao studentDao, SubjectTeacherAssignmentDao subjectTeacherAssignmentDao, StudentAssignmentDao studentAssignmentDao, SubjectAssignmentDao subjectAssignmentDao, SectionAssignmentDao sectionAssignmentDao, AcademicClassMapper academicClassMapper) {
        this.academicYearDao = academicYearDao;
        this.academicClassDao = academicClassDao;
        this.classEntityDao = classEntityDao;
        this.sectionsDao = sectionsDao;
        this.subjectDao = subjectDao;
        this.studentDao = studentDao;
        this.subjectTeacherAssignmentDao = subjectTeacherAssignmentDao;
        this.studentAssignmentDao = studentAssignmentDao;
        this.subjectAssignmentDao = subjectAssignmentDao;
        this.sectionAssignmentDao = sectionAssignmentDao;
        this.academicClassMapper = academicClassMapper;
    }
}

