/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.MainService;

import com.rugaa.NambaSchool.ClassEntity.ClassEntity;
import com.rugaa.NambaSchool.ClassEntity.ClassEntityDto;
import com.rugaa.NambaSchool.MAIN.AcademicClass;
import com.rugaa.NambaSchool.MAIN.SectionAssignment;
import com.rugaa.NambaSchool.MainDto.AcademicClassDTO;
import com.rugaa.NambaSchool.academics.AcademicYear;
import com.rugaa.NambaSchool.academics.AcademicYearDto;
import com.rugaa.NambaSchool.sections.Sections;
import com.rugaa.NambaSchool.sections.SectionsDto;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class AcademicClassMapper {
    public AcademicClassDTO toDto(AcademicClass academicClass) {
        ArrayList sectionDTOs = academicClass.getSections() != null ? academicClass.getSections().stream().map(sectionAssignment -> {
            Sections section = sectionAssignment.getSection();
            return SectionsDto.builder().id(section.getId()).sectionName(section.getSectionName()).build();
        }).collect(Collectors.toList()) : new ArrayList();
        ClassEntity classEntity = academicClass.getClassEntity();
        AcademicYear academicYear = academicClass.getAcademicYear();
        return AcademicClassDTO.builder().id(academicClass.getId()).academicYear(AcademicYearDto.builder().id(academicYear.getId()).name(academicYear.getName()).build()).classEntity(ClassEntityDto.builder().id(classEntity.getId()).className(classEntity.getClassName()).build()).sections(sectionDTOs).build();
    }

    public void updateEntityFromDto(AcademicClass academicClass, AcademicClassDTO dto, AcademicYear academicYear, ClassEntity classEntity, List<Sections> sections) {
        academicClass.setAcademicYear(academicYear);
        academicClass.setClassEntity(classEntity);
        List assignments = sections.stream().map(section -> {
            SectionAssignment sa = new SectionAssignment();
            sa.setSection(section);
            sa.setAcademicClass(academicClass);
            return sa;
        }).collect(Collectors.toList());
        academicClass.setSections(assignments);
    }
}

