/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.ClassEntity;

import com.rugaa.NambaSchool.ClassEntity.ClassEntity;
import com.rugaa.NambaSchool.ClassEntity.ClassEntityDao;
import com.rugaa.NambaSchool.ClassEntity.ClassEntityDto;
import com.rugaa.NambaSchool.ClassEntity.ClassEntityMapper;
import com.rugaa.NambaSchool.ClassEntity.ClassEntityService;
import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.schoolregistration.SchoolRegistrationRepository;
import com.rugaa.NambaSchool.subjects.SubjectDao;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ClassEntityServiceImpl
implements ClassEntityService {
    private final ClassEntityDao standardsDao;
    private final ClassEntityMapper standardsMapper;
    private final SubjectDao subjectDao;
    private final SchoolRegistrationRepository schoolRegistrationRepository;

    public ApplicationResponse<ClassEntity> createStandard(ClassEntityDto standardsDto) {
        try {
            ClassEntity standards = this.standardsMapper.mapRequestToEntity(standardsDto);
            if (standardsDto.getSubjectids() != null && !standardsDto.getSubjectids().isEmpty()) {
                List subjects = this.subjectDao.findAllById(standardsDto.getSubjectids());
                standards.setSubjects(subjects);
            }
            ClassEntity saveStandards = this.standardsDao.createStandard(standards);
            return ApplicationResponse.success((String)"Succefully create Standards", (Object)saveStandards);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while create Standards" + e.getMessage()));
        }
    }

    public ApplicationResponse<List<ClassEntityDto>> findAll() {
        try {
            List standards = this.standardsDao.findAll();
            if (standards.isEmpty()) {
                return ApplicationResponse.error((String)"Standards is not found");
            }
            List standardsDtos = standards.stream().map(arg_0 -> ((ClassEntityMapper)this.standardsMapper).mapEntityToDto(arg_0)).collect(Collectors.toList());
            return ApplicationResponse.success((String)"Succefully findAll Standards", standardsDtos);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while findAll Standards" + e.getMessage()));
        }
    }

    public ApplicationResponse<ClassEntityDto> findById(Long id) {
        try {
            Optional optional = this.standardsDao.findById(id);
            if (optional.isPresent()) {
                ClassEntityDto standardsDto = this.standardsMapper.mapEntityToDto((ClassEntity)optional.get());
                return ApplicationResponse.success((String)"Succefully findAll Standards", (Object)standardsDto);
            }
            return ApplicationResponse.error((String)"Subject is not found");
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find By Standards id" + e.getMessage()));
        }
    }

    public ApplicationResponse<ClassEntity> updateById(ClassEntityDto standardsDto, Long id) {
        try {
            Optional optional = this.standardsDao.findById(id);
            ClassEntity subject = (ClassEntity)optional.get();
            this.standardsMapper.updateRequestFromEntity(subject, standardsDto);
            if (standardsDto.getSubjectids() != null) {
                subject.getSubjects().clear();
                List subjects = this.subjectDao.findAllById(standardsDto.getSubjectids());
                subject.setSubjects(subjects);
            }
            ClassEntity saveStandards = this.standardsDao.createStandard(subject);
            return ApplicationResponse.success((String)"Succefully update by Standards", (Object)saveStandards);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update By Standards id" + e.getMessage()));
        }
    }

    public ApplicationResponse<ClassEntity> deleteById(Long id) {
        try {
            Optional existSubject = this.standardsDao.findById(id);
            if (existSubject.isEmpty()) {
                return ApplicationResponse.error((String)"Standards id is not found");
            }
            this.standardsDao.deleteById(id);
            return ApplicationResponse.success((String)"Succefully delete by Standards id", null);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete By Standards id" + e.getMessage()));
        }
    }

    @Generated
    public ClassEntityServiceImpl(ClassEntityDao standardsDao, ClassEntityMapper standardsMapper, SubjectDao subjectDao, SchoolRegistrationRepository schoolRegistrationRepository) {
        this.standardsDao = standardsDao;
        this.standardsMapper = standardsMapper;
        this.subjectDao = subjectDao;
        this.schoolRegistrationRepository = schoolRegistrationRepository;
    }
}

