/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.FindClub.service;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.rugaa.FindClub.request.ResponseBannerDTO;
import com.rugaa.FindClub.service.FileService;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.imageio.ImageIO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class UserPhotoService {
    @Autowired
    private FileService fileService;

    public ResponseBannerDTO addProfile(MultipartFile file) {
        try {
            if (file.isEmpty()) {
                throw new IllegalArgumentException("File cannot be empty.");
            }
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("ddMMyyyyHHmmssSSS");
            LocalDateTime current = LocalDateTime.now();
            String contentType = file.getContentType();
            if (contentType == null) {
                throw new IllegalArgumentException("Invalid file type.");
            }
            String extension = contentType.substring(contentType.lastIndexOf("/") + 1);
            String fileName = dtf.format(current) + "." + extension;
            String remotePath = "/FindClub/" + fileName;
            this.fileService.upload(remotePath, file);
            String uploadedUrl = "https://storage.megashop.my" + remotePath;
            return new ResponseBannerDTO(uploadedUrl);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Error: " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error occurred while processing the file: " + e.getMessage());
        }
    }

    public byte[] generateTransparentQRCodeImage(String text, int width, int height) throws WriterException, IOException {
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        BitMatrix bitMatrix = qrCodeWriter.encode(text, BarcodeFormat.QR_CODE, width, height);
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(new Color(0, 0, 0, 0));
        graphics.fillRect(0, 0, width, height);
        graphics.setColor(Color.BLACK);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (!bitMatrix.get(x, y)) continue;
                graphics.fillRect(x, y, 1, 1);
            }
        }
        graphics.dispose();
        ByteArrayOutputStream pngOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "PNG", pngOutputStream);
        return pngOutputStream.toByteArray();
    }

    public ByteArrayResource uploadAndGenerateQRCode(String fileUrl) {
        try {
            byte[] qrCodeImage = this.generateTransparentQRCodeImage(fileUrl, 250, 250);
            ByteArrayResource resource = new ByteArrayResource(qrCodeImage);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.IMAGE_PNG);
            headers.setContentLength((long)qrCodeImage.length);
            headers.set("Content-Disposition", "attachment; filename=QRCode.png");
            return resource;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

