/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.FindClub.service;

import com.rugaa.FindClub.dao.SubscriptionDao;
import com.rugaa.FindClub.model.ClubModel;
import com.rugaa.FindClub.model.Subscription;
import com.rugaa.FindClub.repository.ClubModelRepository;
import com.rugaa.FindClub.repository.SubscriptionRepository;
import com.rugaa.FindClub.request.ClubRequest;
import com.rugaa.FindClub.request.SubscriptionRequest;
import com.rugaa.FindClub.response.ResponseDto;
import com.rugaa.FindClub.service.SubscriptionServices;
import jakarta.persistence.EntityNotFoundException;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SubscriptionServicesImpl
implements SubscriptionServices {
    @Autowired
    private SubscriptionDao subscriptionDao;
    @Autowired
    private SubscriptionRepository subscriptionRepository;
    private ClubModelRepository clubModelRepository;

    public Subscription createSubscription(SubscriptionRequest request) {
        try {
            Subscription subscription = new Subscription();
            if (request.getPlanName() == null) {
                new ResponseDto("error", "planName mandatory", "");
            }
            if (request.getDescription() == null) {
                new ResponseDto("error", "description mandatory", "");
            }
            if (request.getStatus() == null) {
                new ResponseDto("error", "status mandatory", "");
            }
            if (request.getCreatedBy() == null) {
                new ResponseDto("error", "createdBy mandatory", "");
            }
            if (request.getUpdatedBy() == null) {
                new ResponseDto("error", "updatedBy mandatory", "");
            }
            subscription.setPlanName(request.getPlanName());
            subscription.setAmount(request.getAmount());
            subscription.setDuration(request.getDuration());
            subscription.setDescription(request.getDescription());
            subscription.setStatus(request.getStatus());
            subscription.setCreatedBy(request.getCreatedBy());
            subscription.setUpdatedBy(request.getUpdatedBy());
            return this.subscriptionDao.createSubscription(subscription);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while create the subscription:" + e.getMessage());
        }
    }

    public List<Subscription> fetchAllSubscription() {
        try {
            return this.subscriptionDao.fetchAllSubscription();
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while find the subscription:" + e.getMessage());
        }
    }

    public Subscription findsubscriptionById(long subId) {
        try {
            return this.subscriptionDao.findsubscriptionById(subId);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while find the subscription id:" + e.getMessage());
        }
    }

    public String deleteSubscriptionById(long subId) {
        try {
            this.subscriptionDao.deleteSubscriptionById(subId);
            return "Deleted id successfully!!";
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while delete the subscriton:" + e.getMessage());
        }
    }

    public Subscription updateSubscriptionById(long subId, SubscriptionRequest request) {
        try {
            Subscription subscriptions = this.subscriptionDao.findsubscriptionById(subId);
            if (subscriptions == null) {
                throw new EntityNotFoundException("subscription not found for id:" + subId);
            }
            if (request.getPlanName() == null) {
                new ResponseDto("error", "planName mandatory", "");
            }
            if (request.getDescription() == null) {
                new ResponseDto("error", "description mandatory", "");
            }
            if (request.getStatus() == null) {
                new ResponseDto("error", "status mandatory", "");
            }
            if (request.getCreatedBy() == null) {
                new ResponseDto("error", "createdBy mandatory", "");
            }
            if (request.getUpdatedBy() == null) {
                new ResponseDto("error", "updatedBy mandatory", "");
            }
            subscriptions.setPlanName(request.getPlanName());
            subscriptions.setAmount(request.getAmount());
            subscriptions.setDuration(request.getDuration());
            subscriptions.setDescription(request.getDescription());
            subscriptions.setStatus(request.getStatus());
            subscriptions.setCreatedBy(request.getCreatedBy());
            subscriptions.setUpdatedBy(request.getUpdatedBy());
            return this.subscriptionDao.updateSubscriptionById(subscriptions);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while update by id subscription:" + e.getMessage());
        }
    }

    public Subscription checkDuration(Long clubid, ClubRequest request) {
        Subscription subscription = new Subscription();
        subscription.setDuration(request.getDuration());
        Optional clubModel = this.clubModelRepository.findById((Object)subscription.getSubId());
        if (clubModel.isPresent()) {
            ClubModel clubModels = (ClubModel)clubModel.get();
            if (clubModels.getId().equals(clubid)) {
                long durationTo = request.getDuration();
                subscription.setDuration(Long.valueOf(subscription.getDuration() - durationTo));
            } else {
                throw new RuntimeException("club not found  subscription id:" + subscription.getSubId());
            }
        }
        return subscription;
    }
}

