/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.FindClub.service;

import com.rugaa.FindClub.dao.UserDao;
import com.rugaa.FindClub.model.User;
import com.rugaa.FindClub.request.PasswordChangeRequest;
import com.rugaa.FindClub.request.ResponseDto;
import com.rugaa.FindClub.request.UserDto;
import com.rugaa.FindClub.service.AuthenticationService;
import com.rugaa.FindClub.service.OTPService;
import com.rugaa.FindClub.utils.EmailSender;
import com.rugaa.FindClub.utils.JavaSendapi;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class PasswordChangeServiceImpl {
    @Autowired
    AuthenticationService authenticationService;
    @Autowired
    PasswordEncoder encoder;
    @Autowired
    UserDao userDao;
    @Autowired
    EmailSender emailSendingUtil;
    @Autowired
    JavaSendapi javaSendapi;

    public ResponseDto sendOtpForAccountCreation(UserDto request) {
        try {
            System.out.println("Generating OTP for account creation...");
            String otp = OTPService.generateOTP();
            System.out.println("OTP generated: " + otp);
            OTPService.storeOTPInDatabase((String)request.getEmail(), (String)otp);
            System.out.println("OTP stored in the database.");
            String body = "<html><p>Welcome to FindClub! To complete your account setup, please use the OTP below:</p><p><strong>Your OTP: " + otp + "</strong></p><p>This OTP is valid for the next 10 minutes. Please enter it on the registration page to verify your email address.</p><p>If you did not request an account with FindClub, please ignore this email.</p><br><p>Best regards,</p><p>The FindClub Team</p><p><a href='mailto:support@findclub.com'>support@findclub.com</a></p><p><a href='https://findclub.com'>findclub.com</a></p></html>";
            String subject = "FindClub Account Verification OTP";
            this.emailSendingUtil.sendMailWithAttachment(request.getEmail(), body, subject);
            return new ResponseDto("Success", "OTP has been sent to your email for account creation.", "Info");
        }
        catch (Exception e) {
            return new ResponseDto("Error", "Something went wrong while sending the OTP.", "Error");
        }
    }

    public ResponseDto verifyOtpForAccountCreation(UserDto request) {
        try {
            boolean isVerified = OTPService.verifyOTP((String)request.getEmail(), (String)request.getOtp());
            if (isVerified) {
                return new ResponseDto("Success", "OTP verified successfully. Account creation can proceed.", "Info");
            }
            return new ResponseDto("Error", "Invalid OTP. Please check and try again.", "Info");
        }
        catch (Exception e) {
            return new ResponseDto("Error", "An error occurred while verifying the OTP.", "Error");
        }
    }

    public ResponseEntity<?> changePassword(PasswordChangeRequest changeRequest, String token) {
        try {
            PasswordChangeRequest password = this.authenticationService.getPassDetails(token);
            if (!this.encoder.matches((CharSequence)changeRequest.getOldpassword(), password.getOldpassword())) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Old password is incorrect");
            }
            if (!changeRequest.getNewpassword().equals(changeRequest.getReenterpassword())) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"New password and re-entered password do not match");
            }
            Optional userOpt = this.userDao.findById(changeRequest.getUserid());
            if (userOpt.isEmpty()) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).body((Object)"User not found");
            }
            User user = (User)userOpt.get();
            String newPassword = changeRequest.getNewpassword();
            user.setPassword(this.encoder.encode((CharSequence)newPassword));
            this.userDao.save(user);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)"Password changed successfully");
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while changing the password: " + e.getMessage()));
        }
    }

    public ResponseDto forgotpassword(UserDto request) {
        try {
            System.out.println("request.getEmail(): " + request.getEmail());
            if (request.getEmail() == null && request.getRole() == null) {
                return new ResponseDto("Error", "Email is required.", "Test");
            }
            Optional user = this.userDao.findByEmailandRole(request.getEmail(), request.getRole());
            if (!user.isPresent()) {
                return new ResponseDto("Error", "User not found with the provided email.", "Test");
            }
            if (request.getOtp() == null) {
                return new ResponseDto("Error", "OTP is required.", "Test");
            }
            if (request.getPassword() == null) {
                return new ResponseDto("Error", "New password is required.", "Test");
            }
            boolean isVerified = OTPService.verifyOTP((String)request.getEmail(), (String)request.getOtp());
            if (!isVerified) {
                return new ResponseDto("Error", "Invalid OTP.", "Test");
            }
            ((User)user.get()).setPassword(this.encoder.encode((CharSequence)request.getPassword()));
            this.userDao.save((User)user.get());
            return new ResponseDto("Success", "Password changed successfully.", "Test");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResponseDto("Error", "An unexpected error occurred. Please try again later.", "Test");
        }
    }

    public ResponseDto forgotpassotp(UserDto request) {
        try {
            System.out.println("2");
            Optional user = this.userDao.findByEmailandRole(request.getEmail(), request.getRole());
            System.out.println("3");
            String name = ((User)user.get()).getName();
            String otp = OTPService.generateOTP();
            System.out.println("4");
            if (request.getEmail() != null && user.isPresent()) {
                OTPService.storeOTPInDatabase((String)request.getEmail(), (String)otp);
                System.out.println("5");
                try {
                    String body = "<html><body style='font-family: Arial, sans-serif;'><p>Dear " + name + ",</p><p>We received a request to reset the password for your FindClub account. Please use the OTP below to proceed with resetting your password:</p><p style='font-size: 18px;'><strong>Your OTP: " + otp + "</strong></p><p>This OTP is valid for the next 10 minutes. If you didn\u2019t request a password reset, please disregard this email or contact our support team immediately.</p><br><p>If you need assistance, feel free to reach out to us at <a href='mailto:support@findclub.com'>support@findclub.com</a>.</p><br><p>Thank you for using FindClub!</p><br><p>Best regards,</p><p>The FindClub Team</p><p><a href='mailto:support@findclub.com'>support@findclub.com</a></p><p><a href='https://findclub.com'>findclub.com</a></p></body></html>";
                    String subject = "FindClub Password Reset Request - OTP";
                    this.emailSendingUtil.sendMailWithAttachment(request.getEmail(), body, subject);
                }
                catch (Exception e) {
                    ResponseDto response = new ResponseDto("Error", "Something went wrong", "Test");
                    return response;
                }
                ResponseDto response = new ResponseDto("Success", "Otp has sent to your email", "Test");
                return response;
            }
            ResponseDto response = new ResponseDto("Error", "Something went wrong", "Test");
            return response;
        }
        catch (Exception e) {
            ResponseDto response = new ResponseDto("Error", "Something went wrong", "Test");
            return response;
        }
    }
}

