/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.FindClub.service;

import com.rugaa.FindClub.dao.OfferDao;
import com.rugaa.FindClub.model.ClubModel;
import com.rugaa.FindClub.model.Offer;
import com.rugaa.FindClub.model.Role;
import com.rugaa.FindClub.repository.ClubModelRepository;
import com.rugaa.FindClub.request.OfferRequest;
import com.rugaa.FindClub.response.UserResponse;
import com.rugaa.FindClub.service.AuthenticationService;
import com.rugaa.FindClub.service.ClubModelServices;
import com.rugaa.FindClub.service.OfferServices;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OfferServicesImpl
implements OfferServices {
    @Autowired
    private OfferDao offerDao;
    @Autowired
    private AuthenticationService authenticationService;
    @Autowired
    ClubModelServices clubModelServices;
    @Autowired
    ClubModelRepository clubModelRepository;

    public Offer createOffer(OfferRequest offerRequest, String token) {
        try {
            UserResponse response = this.authenticationService.getDetails(token);
            Offer offer = new Offer();
            offer.setOfferTitle(offerRequest.getOfferTitle());
            offer.setClubid(response.getClubid());
            offer.setStartDate(offerRequest.getStartDate());
            offer.setEndDate(offerRequest.getEndDate());
            offer.setStarttime(offerRequest.getStarttime());
            offer.setEndtime(offerRequest.getEndtime());
            offer.setDescription(offerRequest.getDescription());
            offer.setOfferimage(offerRequest.getOfferimage());
            Optional clubs = this.clubModelRepository.findById((Object)response.getClubid());
            if (clubs.isEmpty()) {
                throw new RuntimeException("Club not found for gallery ID: " + response.getClubid());
            }
            offer.setClubname(((ClubModel)clubs.get()).getClubName());
            return this.offerDao.createOffer(offer);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while create offer:" + e.getMessage());
        }
    }

    public List<Offer> fetchAllOffer(String token) {
        try {
            List offers;
            UserResponse response = this.authenticationService.getDetails(token);
            if (response.getRole().equals((Object)Role.CLIENT)) {
                offers = this.offerDao.fetchAllOfferById(response.getClubid());
            } else {
                offers = this.offerDao.fetchAllOffer();
                LocalDate currentDate = LocalDate.now();
                LocalTime currentTime = LocalTime.now();
                offers = offers.stream().filter(offer -> !(!offer.getStartDate().isBefore(currentDate) && !offer.getStartDate().isEqual(currentDate) || !offer.getEndDate().isAfter(currentDate) && !offer.getEndDate().isEqual(currentDate))).collect(Collectors.toList());
            }
            return offers;
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while fetching offers: " + e.getMessage(), e);
        }
    }

    public Optional<Offer> findOfferById(long id) {
        try {
            return this.offerDao.findOfferById(id);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while find by id offer:" + e.getMessage());
        }
    }

    public void deleteOfferById(long id) {
        try {
            this.offerDao.deleteOfferById(id);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while delete by offer id:" + e.getMessage());
        }
    }

    public Offer updateOfferById(long id, OfferRequest offerRequest) {
        try {
            Optional offerId = this.offerDao.findOfferById(id);
            Offer offer = (Offer)offerId.get();
            offer.setOfferTitle(offerRequest.getOfferTitle());
            offer.setClubid(offerRequest.getClubid());
            offer.setStartDate(offerRequest.getStartDate());
            offer.setEndDate(offerRequest.getEndDate());
            offer.setDescription(offerRequest.getDescription());
            offer.setOfferimage(offerRequest.getOfferimage());
            return this.offerDao.createOffer(offer);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while updete the offer id:" + e.getMessage());
        }
    }
}

