/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.FindClub.service;

import com.rugaa.FindClub.dao.EventDao;
import com.rugaa.FindClub.model.Events;
import com.rugaa.FindClub.model.Role;
import com.rugaa.FindClub.request.EventRequest;
import com.rugaa.FindClub.response.ResponseDto;
import com.rugaa.FindClub.response.UserResponse;
import com.rugaa.FindClub.service.AuthenticationService;
import com.rugaa.FindClub.service.EventServices;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EventServicesImpl
implements EventServices {
    @Autowired
    private EventDao eventDao;
    @Autowired
    private AuthenticationService authenticationService;

    public Events createEvent(EventRequest eventRequest) {
        try {
            Events events = new Events();
            events.setEventTitle(eventRequest.getEventTitle());
            events.setDescription(eventRequest.getDescription());
            events.setClubid(eventRequest.getClubid());
            events.setEventStartDate(eventRequest.getEventStartDate());
            events.setEventEndDate(eventRequest.getEventEndDate());
            events.setDjname(eventRequest.getDjname());
            events.setStatus(Boolean.valueOf(true));
            events.setTime(eventRequest.getTime());
            events.setSeatcount(eventRequest.getSeatcount());
            events.setEventdate(eventRequest.getEventdate());
            events.setEventimage(eventRequest.getEventimage());
            return this.eventDao.createEvent(events);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while create Event:" + e.getMessage());
        }
    }

    public List<Events> fetchAllEvents(String token) {
        try {
            UserResponse user = this.authenticationService.getDetails(token);
            if (user.getRole().equals((Object)Role.CLIENT)) {
                return this.eventDao.getAllClub(user.getClubid());
            }
            return this.eventDao.fetchAllEvents();
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while fetch all Event" + e.getMessage());
        }
    }

    public Events findEventsById(long eventId) {
        try {
            Optional events = this.eventDao.findEventsById(eventId);
            return (Events)events.get();
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while find by id Evenet:" + e.getMessage());
        }
    }

    public void deleteEventsById(long eventId) {
        try {
            this.eventDao.deleteEventsById(eventId);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while delete by id Event" + e.getMessage());
        }
    }

    public Events updateEventsById(long eventId, EventRequest eventRequest) {
        try {
            Optional event = this.eventDao.findEventsById(eventId);
            Events events = (Events)event.get();
            if (eventRequest.getEventTitle() == null) {
                new ResponseDto("error", "eventTitle mandatory", "");
            }
            if (eventRequest.getDescription() == null) {
                new ResponseDto("error", "description mandatory", "");
            }
            events.setEventTitle(eventRequest.getEventTitle());
            events.setDescription(eventRequest.getDescription());
            events.setClubid(eventRequest.getClubid());
            events.setEventStartDate(eventRequest.getEventStartDate());
            events.setEventEndDate(eventRequest.getEventEndDate());
            events.setDjname(eventRequest.getDjname());
            events.setTime(eventRequest.getTime());
            events.setStatus(eventRequest.getStatus());
            events.setSeatcount(eventRequest.getSeatcount());
            events.setEventdate(eventRequest.getEventdate());
            events.setEventimage(eventRequest.getEventimage());
            return this.eventDao.updateEventsById(events);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while updated by bid Event:" + e.getMessage());
        }
    }

    public List<Events> findByEventClub(Long id) {
        try {
            return this.eventDao.findByEventClub(id);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while findByEvenetClub:" + e.getMessage());
        }
    }
}

