/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.FindClub.service;

import com.rugaa.FindClub.dao.CustomerDao;
import com.rugaa.FindClub.model.Customer;
import com.rugaa.FindClub.model.Role;
import com.rugaa.FindClub.model.User;
import com.rugaa.FindClub.repository.UserRepository;
import com.rugaa.FindClub.request.CustomerRequest;
import com.rugaa.FindClub.request.ResponseBannerDTO;
import com.rugaa.FindClub.response.AuthenticationResponse;
import com.rugaa.FindClub.security.JwtService;
import com.rugaa.FindClub.service.ByteArrayResourceMultipartFile;
import com.rugaa.FindClub.service.CustomerService;
import com.rugaa.FindClub.service.UserPhotoService;
import jakarta.persistence.EntityNotFoundException;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CustomerServiceImpl
implements CustomerService {
    @Autowired
    private CustomerDao customerDao;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private PasswordEncoder encoder;
    @Autowired
    private UserPhotoService photoService;
    @Autowired
    private JwtService jwtService;
    @Autowired
    private UserPhotoService userPhotoService;

    public AuthenticationResponse createUser(CustomerRequest request) {
        try {
            System.out.println("Starting createUser process");
            Customer customer = new Customer();
            customer.setName(request.getName());
            customer.setEmail(request.getEmail());
            customer.setPassword(this.encoder.encode((CharSequence)request.getPassword()));
            customer.setMobile(request.getMobile());
            customer.setDob(request.getDob());
            customer.setStatus(Boolean.valueOf(true));
            if (request.getProfile() == null) {
                customer.setProfile("https://storage.megashop.my/FindClub/16112024213328714.jpeg");
            } else {
                customer.setProfile(request.getProfile());
            }
            customer.setAddress(request.getAddress());
            customer.setLocation(request.getLocation());
            Customer savedCustomer = this.customerDao.createUser(customer);
            System.out.println("Saving customer in database with User ID");
            User user = new User();
            user.setName(request.getName());
            user.setEmail(request.getEmail());
            user.setPassword(this.encoder.encode((CharSequence)request.getPassword()));
            user.setStatus(Boolean.valueOf(true));
            user.setMobile(request.getMobile());
            user.setRole(Role.USER);
            user.setUserid(savedCustomer.getId());
            User savedUser = (User)this.userRepository.save((Object)user);
            savedCustomer.setUserid(savedUser.getId());
            System.out.println("Saving customer in database with User ID");
            String qrUrl = savedCustomer.getId().toString();
            byte[] qrCodeBytes = this.userPhotoService.generateTransparentQRCodeImage(qrUrl, 250, 250);
            ByteArrayResourceMultipartFile qrCodeFile = new ByteArrayResourceMultipartFile(new ByteArrayResource(qrCodeBytes), "QRCode.png", "image/png");
            ResponseBannerDTO qrCodeUrl = this.photoService.addProfile((MultipartFile)qrCodeFile);
            savedCustomer.setQrcode(qrCodeUrl.getUploadedUrl().toString());
            this.customerDao.createUser(savedCustomer);
            String jwtToken = this.jwtService.generateToken((UserDetails)savedUser);
            return AuthenticationResponse.builder().token(jwtToken).build();
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Validation error: " + e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while creating the customer: " + e.getMessage());
        }
    }

    public MultipartFile convertResponseEntityToMultipartFile(ByteArrayResource responseEntity, String fileName, String contentType) {
        if (responseEntity == null) {
            throw new IllegalArgumentException("ByteArrayResource is null");
        }
        return new ByteArrayResourceMultipartFile(responseEntity, fileName, contentType);
    }

    public List<Customer> getAllUserModel() {
        try {
            return this.customerDao.getAllUserModel();
        }
        catch (Exception e) {
            throw new EntityNotFoundException("An error occurred while not found the customer:" + e.getMessage());
        }
    }

    public Optional<Customer> findUserModelById(long userid) {
        try {
            return this.customerDao.findUserModelById(userid);
        }
        catch (Exception e) {
            throw new EntityNotFoundException("An error occurred while find the customer:" + e.getMessage());
        }
    }

    public void deleteUserModelById(long userid) {
        try {
            this.customerDao.deleteUserModelById(userid);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while delete the customer:" + e.getMessage());
        }
    }

    public Customer updateUserModelById(long userid, CustomerRequest request) {
        try {
            Optional userOptional = this.customerDao.findUserModelById(userid);
            Customer customer = (Customer)userOptional.get();
            customer.setName(request.getName());
            customer.setEmail(request.getEmail());
            customer.setMobile(request.getMobile());
            customer.setDob(request.getDob());
            customer.setStatus(request.getStatus());
            customer.setProfile(request.getProfile());
            customer.setAddress(request.getAddress());
            customer.setLocation(request.getLocation());
            return this.customerDao.updateUserModelById(customer);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while update the customer:" + e.getMessage());
        }
    }
}

