/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.FindClub.service;

import com.rugaa.FindClub.model.ClubModel;
import com.rugaa.FindClub.model.Customer;
import com.rugaa.FindClub.model.CustomerGallery;
import com.rugaa.FindClub.repository.ClubModelRepository;
import com.rugaa.FindClub.repository.CustomerGalleryRepository;
import com.rugaa.FindClub.repository.CustomerRepository;
import com.rugaa.FindClub.request.CustomerGalleryRequest;
import com.rugaa.FindClub.response.UserResponse;
import com.rugaa.FindClub.service.AuthenticationService;
import com.rugaa.FindClub.service.ClubModelServices;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomerGalleryService {
    @Autowired
    private CustomerGalleryRepository customerGalleryRepository;
    @Autowired
    private CustomerRepository customerRepository;
    @Autowired
    private ClubModelServices clubModelServices;
    @Autowired
    private AuthenticationService authenticationService;
    @Autowired
    ClubModelRepository clubModelRepository;

    public List<CustomerGallery> getAllGalleries(String token) {
        try {
            return this.customerGalleryRepository.findAll();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Optional<CustomerGallery> getGalleryById(Long id) {
        try {
            return this.customerGalleryRepository.findById((Object)id);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public List<CustomerGallery> getGallery(String token) {
        try {
            UserResponse response = this.authenticationService.getDetails(token);
            Long cusid = response.getUserid();
            return this.customerGalleryRepository.findByCustomerId(cusid);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public CustomerGallery createGallery(CustomerGalleryRequest galleryRequest, Long customerId) {
        try {
            Optional customerOpt = this.customerRepository.findById((Object)customerId);
            if (customerOpt.isEmpty()) {
                throw new RuntimeException("Customer not found with ID: " + customerId);
            }
            if (galleryRequest.getClubid() == null || galleryRequest.getGalleryimage() == null) {
                throw new RuntimeException("Required fields (clubid, galleryimage) are missing.");
            }
            CustomerGallery gallery = new CustomerGallery();
            gallery.setClubid(galleryRequest.getClubid());
            gallery.setGalleryimage(galleryRequest.getGalleryimage());
            gallery.setDescription(galleryRequest.getDescription());
            gallery.setCreatedAt(galleryRequest.getCreatedAt());
            gallery.setCustomer((Customer)customerOpt.get());
            Optional clubs = this.clubModelRepository.findById((Object)gallery.getClubid());
            if (clubs.isEmpty()) {
                throw new RuntimeException("Club not found for gallery ID: " + gallery.getClubid());
            }
            gallery.setClubname(((ClubModel)clubs.get()).getClubName());
            return (CustomerGallery)this.customerGalleryRepository.save((Object)gallery);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while creating the gallery: " + e.getMessage(), e);
        }
    }

    public CustomerGallery updateGallery(Long id, CustomerGallery updatedGallery) {
        try {
            Optional galleryOpt = this.customerGalleryRepository.findById((Object)id);
            if (galleryOpt.isPresent()) {
                CustomerGallery existingGallery = (CustomerGallery)galleryOpt.get();
                existingGallery.setClubid(updatedGallery.getClubid());
                existingGallery.setGalleryimage(updatedGallery.getGalleryimage());
                return (CustomerGallery)this.customerGalleryRepository.save((Object)existingGallery);
            }
            throw new RuntimeException("Gallery not found with ID: " + id);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean deleteGallery(Long id) {
        try {
            if (this.customerGalleryRepository.existsById((Object)id)) {
                this.customerGalleryRepository.deleteById((Object)id);
                return true;
            }
            throw new RuntimeException("Gallery not found with ID: " + id);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

