/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.FindClub.service;

import com.rugaa.FindClub.dao.ClubModelDao;
import com.rugaa.FindClub.model.ClubModel;
import com.rugaa.FindClub.model.Role;
import com.rugaa.FindClub.model.User;
import com.rugaa.FindClub.repository.EventRepository;
import com.rugaa.FindClub.repository.SubscriptionRepository;
import com.rugaa.FindClub.repository.UserRepository;
import com.rugaa.FindClub.request.ClubRequest;
import com.rugaa.FindClub.response.AuthenticationResponse;
import com.rugaa.FindClub.response.UserResponse;
import com.rugaa.FindClub.security.JwtService;
import com.rugaa.FindClub.service.AuthenticationService;
import com.rugaa.FindClub.service.ClubModelServices;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class ClubModelServicesImpl
implements ClubModelServices {
    @Autowired
    private ClubModelDao clubModelDao;
    @Autowired
    private PasswordEncoder encoder;
    @Autowired
    private UserRepository userUserRepository;
    @Autowired
    private EventRepository eventRepository;
    @Autowired
    private SubscriptionRepository subscriptionRepository;
    @Autowired
    JwtService jwtService;
    @Autowired
    private AuthenticationService authenticationService;

    public AuthenticationResponse saveUser(ClubRequest request) {
        try {
            ClubModel clubModel = new ClubModel();
            clubModel.setClubName(request.getClubName());
            clubModel.setContactPerson(request.getContactPerson());
            clubModel.setPassword(this.encoder.encode((CharSequence)request.getPassword()));
            clubModel.setEmail(request.getEmail());
            clubModel.setMobileNumber(request.getMobileNumber());
            if (request.getProfileimg() == null) {
                clubModel.setProfileimg("https://storage.megashop.my/FindClub/16112024213328714.jpeg");
            } else {
                clubModel.setProfileimg(request.getProfileimg());
            }
            clubModel.setPlanStatus(Boolean.valueOf(true));
            clubModel.setStatus(Boolean.valueOf(true));
            clubModel.setSubId(Long.valueOf(1L));
            clubModel.setLocation(request.getLocation());
            clubModel.setAddress(request.getAddress());
            clubModel.setOpeningtime(request.getOpeningtime());
            clubModel.setClosingtime(request.getOpeningtime());
            ClubModel saved = this.clubModelDao.saveUser(clubModel);
            User user = new User();
            user.setName(saved.getClubName());
            user.setEmail(saved.getEmail());
            user.setPassword(this.encoder.encode((CharSequence)request.getPassword()));
            user.setMobile(saved.getMobileNumber());
            user.setClubid(saved.getId());
            user.setStatus(Boolean.valueOf(true));
            user.setRole(Role.CLIENT);
            User users = (User)this.userUserRepository.save((Object)user);
            saved.setClubid(users.getId());
            this.clubModelDao.saveUser(saved);
            String jwtToken = this.jwtService.generateToken((UserDetails)users);
            return AuthenticationResponse.builder().token(jwtToken).build();
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while create clubModel:" + e.getMessage());
        }
    }

    public void deleteUserById(long clubId) {
        try {
            this.clubModelDao.deleteUserById(clubId);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occuured while  delete  by id clubModel:" + e.getMessage());
        }
    }

    public ClubModel findUserById(long clubId) {
        try {
            Optional clubOptional = this.clubModelDao.findUserById(clubId);
            return (ClubModel)clubOptional.get();
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while find by id clubModel:" + e.getMessage());
        }
    }

    public List<ClubModel> fetchAllUser(String as) {
        try {
            UserResponse user = this.authenticationService.getDetails(as);
            if (user.getRole().equals((Object)Role.CLIENT)) {
                return this.clubModelDao.getAllClub(user.getClubid());
            }
            return this.clubModelDao.fetchAllUser();
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while fetch all the clubModel:" + e.getMessage());
        }
    }

    public ClubModel updateUserById(long clubId, ClubRequest request) {
        try {
            Optional clubOptional = this.clubModelDao.findUserById(clubId);
            ClubModel clubModel = (ClubModel)clubOptional.get();
            clubModel.setClubName(request.getClubName());
            clubModel.setContactPerson(request.getContactPerson());
            clubModel.setMobileNumber(request.getMobileNumber());
            clubModel.setProfileimg(request.getProfileimg());
            clubModel.setPlanStatus(request.getPlanStatus());
            clubModel.setStatus(request.getStatus());
            clubModel.setSubId(request.getSubId());
            clubModel.setLocation(request.getLocation());
            clubModel.setAddress(request.getAddress());
            clubModel.setTotalseatcount(request.getTotalseatcount());
            clubModel.setOpeningtime(request.getOpeningtime());
            clubModel.setClosingtime(request.getOpeningtime());
            return this.clubModelDao.updateUserById(clubModel);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while update by id clubModel:" + e.getMessage());
        }
    }

    public List<ClubModel> fetchAllLocation() {
        return this.clubModelDao.fetchAllLocation();
    }

    public List<ClubModel> findByLocation(String location) {
        return this.clubModelDao.findByLocation(location);
    }

    public List<ClubModel> findByClub(String as) {
        try {
            UserResponse userResponse = this.authenticationService.getDetails(as);
            if (userResponse != null && userResponse.getClubid() != null) {
                return this.clubModelDao.getAllClub(userResponse.getClubid());
            }
            throw new IllegalArgumentException("club details could not be found");
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while getall club:" + e.getMessage());
        }
    }

    public List<ClubModel> findByClubId(Long id) {
        try {
            return this.clubModelDao.getAllClub(id);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while getall club:" + e.getMessage());
        }
    }
}

