/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.FindClub.service;

import com.rugaa.FindClub.dao.BookingDao;
import com.rugaa.FindClub.model.Booking;
import com.rugaa.FindClub.model.ClubModel;
import com.rugaa.FindClub.model.Events;
import com.rugaa.FindClub.model.Role;
import com.rugaa.FindClub.repository.ClubModelRepository;
import com.rugaa.FindClub.repository.EventRepository;
import com.rugaa.FindClub.request.BookingRequest;
import com.rugaa.FindClub.request.ResponseBannerDTO;
import com.rugaa.FindClub.response.UserResponse;
import com.rugaa.FindClub.service.AuthenticationService;
import com.rugaa.FindClub.service.BookingServices;
import com.rugaa.FindClub.service.ByteArrayResourceMultipartFile;
import com.rugaa.FindClub.service.UserPhotoService;
import jakarta.persistence.EntityNotFoundException;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BookingServicesImpl
implements BookingServices {
    @Autowired
    private BookingDao bookingDao;
    @Autowired
    private UserPhotoService photoService;
    @Autowired
    private EventRepository eventRepository;
    @Autowired
    private AuthenticationService authenticationService;
    @Autowired
    ClubModelRepository clubModelRepository;
    @Autowired
    private UserPhotoService userPhotoService;

    public Booking createBooking(BookingRequest bookingRequest) {
        try {
            Booking booking = new Booking();
            booking.setUserid(bookingRequest.getUserid());
            booking.setEventId(bookingRequest.getEventId());
            booking.setClubid(bookingRequest.getClubid());
            booking.setNoOfMembers(bookingRequest.getNoOfMembers());
            booking.setBookingDate(LocalDate.now());
            Optional clubs = this.clubModelRepository.findById((Object)booking.getClubid());
            if (clubs.isEmpty()) {
                throw new RuntimeException("Club not found for gallery ID: " + booking.getClubid());
            }
            booking.setClubname(((ClubModel)clubs.get()).getClubName());
            booking.setQrvalid(Boolean.valueOf(true));
            booking.setDescription(null);
            Booking savedBooking = this.bookingDao.createBooking(booking);
            String qrurl = booking.getBookId().toString();
            byte[] qrCodeBytes = this.userPhotoService.generateTransparentQRCodeImage(qrurl, 250, 250);
            ByteArrayResourceMultipartFile file = new ByteArrayResourceMultipartFile(new ByteArrayResource(qrCodeBytes), "QRCode.png", "image/png");
            ResponseBannerDTO qrcodeurl = this.photoService.addProfile((MultipartFile)file);
            booking.setQrcode(qrcodeurl.getUploadedUrl().toString());
            Events event = (Events)this.eventRepository.findById((Object)bookingRequest.getEventId()).orElseThrow(() -> new RuntimeException("Event not found"));
            if (event.getSeatcount() < bookingRequest.getNoOfMembers()) {
                throw new RuntimeException("Not enough seats available");
            }
            event.setSeatcount(Integer.valueOf(event.getSeatcount() - bookingRequest.getNoOfMembers()));
            this.eventRepository.save((Object)event);
            savedBooking.setConfirmationStatus(Boolean.valueOf(true));
            Booking savedBookings = this.bookingDao.createBooking(savedBooking);
            return savedBookings;
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while creating the booking: " + e.getMessage(), e);
        }
    }

    public List<Booking> findAllBooking(String as) {
        try {
            UserResponse user = this.authenticationService.getDetails(as);
            if (user.getRole().equals((Object)Role.CLIENT)) {
                return this.bookingDao.getAllClub(user.getClubid());
            }
            List<Booking> bookings = this.bookingDao.findByUserid(user.getUserid());
            bookings = bookings.stream().filter(booking -> booking.getQrvalid()).collect(Collectors.toList());
            return bookings;
        }
        catch (Exception e) {
            throw new EntityNotFoundException("Not find the booking:" + e.getMessage());
        }
    }

    public List<Booking> findAllBookingHistory(String as) {
        try {
            UserResponse user = this.authenticationService.getDetails(as);
            List bookings = this.bookingDao.findByUserid(user.getUserid());
            return bookings;
        }
        catch (Exception e) {
            throw new EntityNotFoundException("Not find the booking:" + e.getMessage());
        }
    }

    public Optional<Booking> findBookingById(long id) {
        try {
            return this.bookingDao.findBookingById(id);
        }
        catch (Exception e) {
            throw new EntityNotFoundException("An error occurred while not found the booing id:" + e.getMessage());
        }
    }

    public void deleteBookingById(long id) {
        try {
            this.bookingDao.deleteBookingById(id);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while Booking id is not deleted");
        }
    }

    public Booking updateBookingById(long id, BookingRequest bookingRequest) {
        try {
            Optional bookingId = this.bookingDao.findBookingById(id);
            Booking booking = (Booking)bookingId.get();
            booking.setUserid(bookingRequest.getUserid());
            booking.setNoOfMembers(bookingRequest.getNoOfMembers());
            booking.setBookingDate(bookingRequest.getBookingDate());
            booking.setBookingTime(bookingRequest.getBookingTime());
            booking.setConfirmationStatus(bookingRequest.getConfirmationStatus());
            booking.setEventId(bookingRequest.getEventId());
            booking.setQrcode(bookingRequest.getQrcode());
            booking.setQrvalid(bookingRequest.getQrvalid());
            return this.bookingDao.updateBookingById(booking);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while booking id updated" + e.getMessage());
        }
    }

    public Booking updatebookingstatus(long id) {
        try {
            Optional bookingId = this.bookingDao.findBookingById(id);
            if (bookingId.isPresent()) {
                Booking booking = (Booking)bookingId.get();
                booking.setQrvalid(Boolean.valueOf(false));
                return this.bookingDao.updateBookingById(booking);
            }
            throw new EntityNotFoundException("Booking not found with ID: " + id);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while updating booking status: " + e.getMessage(), e);
        }
    }

    public Booking checkConfirmStatus(long bookId, BookingRequest request) {
        try {
            Booking booking = (Booking)this.bookingDao.findBookingById(bookId).get();
            booking.setClubid(request.getClubid());
            booking.setUserid(request.getUserid());
            booking.setNoOfMembers(request.getNoOfMembers());
            booking.setBookingDate(request.getBookingDate());
            booking.setBookingTime(request.getBookingTime());
            booking.setEventId(request.getEventId());
            booking.setQrcode(request.getQrcode());
            booking.setQrvalid(request.getQrvalid());
            booking.setBookingTime(request.getBookingTime());
            if (booking.getBookId() == booking.getClubid()) {
                booking.setConfirmationStatus(Boolean.valueOf(true));
            } else if (booking.getBookId() != booking.getClubid()) {
                booking.setConfirmationStatus(Boolean.valueOf(false));
            }
            return this.bookingDao.checkConfirmStatus(booking);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while confirm the booking:" + e.getMessage());
        }
    }

    public MultipartFile convertResponseEntityToMultipartFile(ByteArrayResource responseEntity, String fileName, String contentType) {
        if (responseEntity == null) {
            throw new IllegalArgumentException("ByteArrayResource is null");
        }
        return new ByteArrayResourceMultipartFile(responseEntity, fileName, contentType);
    }

    public List<Booking> getAllClub(Long id) {
        try {
            return this.bookingDao.getAllClub(id);
        }
        catch (Exception e) {
            throw new RuntimeException("could not found club id:" + e.getMessage());
        }
    }

    public List<Booking> findByUserId(Long id) {
        try {
            return this.bookingDao.findByUserid(id);
        }
        catch (Exception e) {
            throw new RuntimeException("could not be found user id:" + e.getMessage());
        }
    }
}

