/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.FindClub.service;

import com.rugaa.FindClub.dao.UserDao;
import com.rugaa.FindClub.model.Role;
import com.rugaa.FindClub.model.User;
import com.rugaa.FindClub.repository.UserRepository;
import com.rugaa.FindClub.request.PasswordChangeRequest;
import com.rugaa.FindClub.request.UserRequest;
import com.rugaa.FindClub.response.AuthenticationResponse;
import com.rugaa.FindClub.response.UserResponse;
import com.rugaa.FindClub.security.JwtService;
import com.rugaa.FindClub.service.AuthenticationService;
import java.util.Base64;
import java.util.Optional;
import lombok.Generated;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class AuthenticationServiceImpl
implements AuthenticationService {
    @Autowired
    public UserRepository userRepository;
    @Autowired
    private final PasswordEncoder encoder;
    @Autowired
    private final JwtService jwtService;
    @Autowired
    private final AuthenticationManager authenticationManager;
    @Autowired
    UserDao userDao;

    public AuthenticationResponse register(UserRequest request) {
        User user = User.builder().name(request.getName()).email(request.getEmail()).password(this.encoder.encode((CharSequence)request.getPassword())).role(request.getRole()).status(Boolean.valueOf(true)).build();
        this.userRepository.save((Object)user);
        String jwtToken = this.jwtService.generateToken((UserDetails)user);
        return AuthenticationResponse.builder().token(jwtToken).build();
    }

    public AuthenticationResponse authenticate(UserRequest request) {
        this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)request.getEmail(), (Object)request.getPassword()));
        User user = (User)this.userRepository.findByEmailAndRole(request.getEmail(), request.getRole()).orElseThrow(() -> new UsernameNotFoundException("User not found for the specified role"));
        if (!user.getStatus().booleanValue()) {
            throw new IllegalStateException("User is not active or has been deactivated");
        }
        String jwtToken = this.jwtService.generateToken((UserDetails)user);
        return AuthenticationResponse.builder().token(jwtToken).build();
    }

    public UserResponse getDetails(String aS) {
        String bearer = aS.substring(aS.indexOf(".") + 1);
        String bearer1 = (String)bearer.subSequence(0, bearer.indexOf("."));
        Base64.Decoder decoder = Base64.getUrlDecoder();
        String token = new String(decoder.decode(bearer1));
        JSONObject jsonObject = new JSONObject(token);
        String userName = jsonObject.getString("sub");
        Optional creator = this.userDao.findByEmail(userName);
        UserResponse res = new UserResponse();
        res.setEmail(((User)creator.get()).getEmail());
        res.setName(((User)creator.get()).getName());
        res.setId(((User)creator.get()).getId());
        res.setClubid(((User)creator.get()).getClubid());
        res.setUserid(((User)creator.get()).getUserid());
        res.setMobile(((User)creator.get()).getMobile());
        res.setRole(((User)creator.get()).getRole());
        return res;
    }

    public void pass() {
        System.out.println("password" + this.encoder.encode((CharSequence)"2020"));
    }

    public PasswordChangeRequest getPassDetails(String aS) {
        String bearer = aS.substring(aS.indexOf(".") + 1);
        String bearer1 = (String)bearer.subSequence(0, bearer.indexOf("."));
        Base64.Decoder decoder = Base64.getUrlDecoder();
        String token = new String(decoder.decode(bearer1));
        JSONObject jsonObject = new JSONObject(token);
        String userName = jsonObject.getString("sub");
        Optional creator = this.userDao.findByEmail(userName);
        if (creator.isPresent()) {
            PasswordChangeRequest res = new PasswordChangeRequest();
            User user = (User)creator.get();
            res.setOldpassword(user.getPassword());
            return res;
        }
        throw new RuntimeException("Error: User not found.");
    }

    public ResponseEntity<?> checkEmail(String email, Role role) {
        try {
            Optional user = this.userDao.findByEmail(email);
            if (user.isPresent()) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Email ID is already present");
            }
            return ResponseEntity.status((HttpStatusCode)HttpStatus.ACCEPTED).body((Object)"Email ID is Available");
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while email:" + e.getMessage());
        }
    }

    public ResponseEntity<?> checkMobileNumber(Long mobileNumber, Role role) {
        try {
            Optional user = this.userDao.findByMobile(mobileNumber);
            if (user.isPresent()) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Mobile number is already present");
            }
            return ResponseEntity.status((HttpStatusCode)HttpStatus.ACCEPTED).body((Object)"Mobile number is Availabe");
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while mobile:" + e.getMessage());
        }
    }

    @Generated
    public AuthenticationServiceImpl(PasswordEncoder encoder, JwtService jwtService, AuthenticationManager authenticationManager) {
        this.encoder = encoder;
        this.jwtService = jwtService;
        this.authenticationManager = authenticationManager;
    }
}

