/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.FindClub.controller;

import com.rugaa.FindClub.model.Subscription;
import com.rugaa.FindClub.request.ClubRequest;
import com.rugaa.FindClub.request.SubscriptionRequest;
import com.rugaa.FindClub.service.SubscriptionServices;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/subscription"})
public class SubscriptionController {
    @Autowired
    private SubscriptionServices subscriptionServices;

    @PostMapping(value={"/save"})
    public ResponseEntity<String> createSubscription(@RequestBody SubscriptionRequest request) {
        try {
            Subscription subscriptions = this.subscriptionServices.createSubscription(request);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)("Subscription is created successfully;" + subscriptions.getSubId()));
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while subscription creater:" + e.getMessage()));
        }
    }

    @GetMapping(value={"/fetchall"})
    public ResponseEntity<?> fetchAllSubscription() {
        try {
            List subscription = this.subscriptionServices.fetchAllSubscription();
            if (subscription.isEmpty()) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"subscription not found");
            }
            return ResponseEntity.ok((Object)subscription);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while retrieving subscription:" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findbyid/{id}"})
    public ResponseEntity<?> findsubscriptionById(@PathVariable(value="id") long subId) {
        try {
            Subscription subscription = this.subscriptionServices.findsubscriptionById(subId);
            return ResponseEntity.ok((Object)subscription);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while retrieving the subscription:" + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/delete/id/{id}"})
    public ResponseEntity<String> deleteSubscriptionById(@PathVariable(value="id") long subId) {
        try {
            this.subscriptionServices.deleteSubscriptionById(subId);
            return ResponseEntity.ok((Object)"Subscription deleted successfully!!");
        }
        catch (ResponseStatusException e) {
            return ResponseEntity.status((HttpStatusCode)e.getStatusCode()).body((Object)e.getReason());
        }
        catch (Exception e) {
            return ResponseEntity.status((int)500).body((Object)("An error occurred while deleted subscription:" + e.getMessage()));
        }
    }

    @PutMapping(value={"/update/id/{id}"})
    public ResponseEntity<String> updateSubscriptionById(@PathVariable(value="id") long subId, @RequestBody SubscriptionRequest request) {
        try {
            Subscription subscription = this.subscriptionServices.updateSubscriptionById(subId, request);
            return ResponseEntity.ok((Object)("Updated subscription id successfully:" + subscription.getSubId()));
        }
        catch (ResponseStatusException e) {
            return ResponseEntity.status((HttpStatusCode)e.getStatusCode()).body((Object)e.getReason());
        }
        catch (Exception e) {
            return ResponseEntity.status((int)500).body((Object)("An error occurred while updated successfully!!:" + e.getMessage()));
        }
    }

    @PostMapping(value={"/checkduration/{id}"})
    public Subscription checkDuration(@PathVariable(value="id") Long clubid, @RequestBody ClubRequest request) {
        return this.subscriptionServices.checkDuration(clubid, request);
    }
}

