/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.FindClub.controller;

import com.rugaa.FindClub.model.Offer;
import com.rugaa.FindClub.request.OfferRequest;
import com.rugaa.FindClub.service.OfferServices;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/offer"})
public class OfferController {
    @Autowired
    private OfferServices offerServices;

    @PostMapping(value={"/save"})
    public ResponseEntity<?> createOffer(@RequestBody OfferRequest offerRequest, @RequestHeader(value="Authorization") String token) {
        try {
            Offer offer = this.offerServices.createOffer(offerRequest, token);
            return ResponseEntity.status((int)200).body((Object)offer);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while create offer:" + e.getMessage()));
        }
    }

    @GetMapping(value={"/fetchall"})
    public ResponseEntity<?> fetchAllOffer(@RequestHeader(value="Authorization") String token) {
        try {
            List offers = this.offerServices.fetchAllOffer(token);
            if (offers.isEmpty()) {
                return ResponseEntity.status((int)404).body((Object)"Not found offer id");
            }
            return ResponseEntity.ok((Object)offers);
        }
        catch (Exception e) {
            return ResponseEntity.status((int)500).body((Object)"An error occurred while not found offer id");
        }
    }

    @GetMapping(value={"/id/{id}"})
    public ResponseEntity<?> findOfferById(@PathVariable(value="id") long id) {
        try {
            Optional offer = this.offerServices.findOfferById(id);
            return ResponseEntity.ok((Object)((Offer)offer.get()));
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while not find offer id:" + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/delete/id/{id}"})
    public ResponseEntity<String> deleteOfferById(@PathVariable(value="id") long id) {
        try {
            this.offerServices.deleteOfferById(id);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)"offer id is deleted successfully");
        }
        catch (ResponseStatusException e) {
            return ResponseEntity.status((HttpStatusCode)e.getStatusCode()).body((Object)e.getReason());
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while delete offer:" + e.getMessage()));
        }
    }

    @PostMapping(value={"/update/id/{id}"})
    public ResponseEntity<?> updateOfferById(@PathVariable long id, @RequestBody OfferRequest offerRequest) {
        try {
            Offer offer = this.offerServices.updateOfferById(id, offerRequest);
            return ResponseEntity.status((int)200).body((Object)offer);
        }
        catch (ResponseStatusException e) {
            return ResponseEntity.status((HttpStatusCode)e.getStatusCode()).body((Object)e.getReason());
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while updated the offer id:" + e.getMessage()));
        }
    }
}

