/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.FindClub.controller;

import com.rugaa.FindClub.model.Events;
import com.rugaa.FindClub.request.EventRequest;
import com.rugaa.FindClub.service.EventServices;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/events"})
public class EventController {
    @Autowired
    private EventServices eventServices;

    @PostMapping(value={"/save"})
    public ResponseEntity<String> createEvent(@RequestBody EventRequest eventRequest) {
        try {
            Events events = this.eventServices.createEvent(eventRequest);
            return ResponseEntity.status((int)201).body((Object)("Event Create Successfully with id:" + events.getEventId()));
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while create the event:" + e.getMessage()));
        }
    }

    @GetMapping(value={"/fetchallevent"})
    public ResponseEntity<?> fetchAllEvents(@RequestHeader(value="Authorization") String token) {
        try {
            List events = this.eventServices.fetchAllEvents(token);
            if (events.isEmpty()) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"No events found:");
            }
            return ResponseEntity.ok((Object)events);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while retrieving the events:" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findevent/{id}"})
    public ResponseEntity<?> findEventsById(@PathVariable(value="id") long eventId) {
        try {
            Events events = this.eventServices.findEventsById(eventId);
            return ResponseEntity.ok((Object)events);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while proccessing your request:" + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/deleteevent/{id}"})
    public ResponseEntity<String> deleteEventsById(@PathVariable(value="id") long eventId) {
        try {
            this.eventServices.deleteEventsById(eventId);
            return ResponseEntity.ok((Object)"Delete Event id is successfully");
        }
        catch (ResponseStatusException e) {
            return ResponseEntity.status((HttpStatusCode)e.getStatusCode()).body((Object)e.getReason());
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while delete the events:" + e.getMessage()));
        }
    }

    @PostMapping(value={"/updateevent/{id}"})
    public ResponseEntity<String> updateEventsById(@PathVariable(value="id") long eventId, @RequestBody EventRequest eventRequest) {
        try {
            Events events = this.eventServices.updateEventsById(eventId, eventRequest);
            return ResponseEntity.ok((Object)("Events updated successfully:" + events.getEventId()));
        }
        catch (ResponseStatusException e) {
            return ResponseEntity.status((HttpStatusCode)e.getStatusCode()).body((Object)e.getReason());
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while update the events:" + e.getMessage()));
        }
    }

    @GetMapping(value={"/getallclub/{id}"})
    public ResponseEntity<?> findByEventClub(@PathVariable Long id) {
        try {
            List events = this.eventServices.findByEventClub(id);
            return new ResponseEntity((Object)events, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
    }
}

